/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.PacketHandler;
import josx.rcxcomm.Tower;
import josx.rcxcomm.TowerException;

public class LLCHandler
extends PacketHandler {
    private byte op;
    private static Tower tower;
    boolean open = false;
    private boolean gotAck = false;
    private boolean gotPacket = false;
    private boolean debug = false;
    private byte[] inPacket = new byte[3];
    private byte[] ackPacket = new byte[2];
    private int inPacketLength;
    private int usbFlag;
    private boolean listen = false;
    private byte[] trash = new byte[1];
    private byte[] keepAlive = new byte[]{-1};
    private long sendTime;

    public LLCHandler(String port) {
        try {
            if (tower == null) {
                tower = new Tower(port);
            }
            if (!this.open) {
                tower.openTower(false);
            }
            this.usbFlag = tower.isUSB() ? 1 : 0;
            this.open = true;
        }
        catch (TowerException e) {
            e.printStackTrace();
        }
    }

    public int getError() {
        return tower.getError();
    }

    public void setListen(boolean listen) {
        this.listen = listen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPacket(byte[] packet, int len) {
        LLCHandler lLCHandler = this;
        synchronized (lLCHandler) {
            if (this.debug) {
                String s = "Sending ";
                s = len == 3 ? s + "packet" : s + "Ack";
                for (int i = 0; i < len; ++i) {
                    s = s + " " + packet[i];
                }
                System.out.println(s);
            }
            this.sendTime = System.currentTimeMillis();
            boolean r = tower.write(packet, len) == len;
            byte[] echo = new byte[len];
            if (this.usbFlag == 0) {
                tower.read(echo, 100);
            }
            return r;
        }
    }

    public int receivePacket(byte[] buffer) {
        if (this.debug) {
            String s = "Receiving Packet";
            for (int i = 0; i < this.inPacketLength; ++i) {
                s = s + " " + this.inPacket[i];
            }
            System.out.println(s);
        }
        this.gotPacket = false;
        for (int i = 0; i < this.inPacketLength; ++i) {
            buffer[i] = this.inPacket[i];
        }
        return this.inPacketLength;
    }

    public int receiveAck(byte[] buffer) {
        if (this.debug) {
            String s = "Receiving Ack";
            for (int i = 0; i < 2; ++i) {
                s = s + " " + this.ackPacket[i];
            }
            System.out.println(s);
        }
        this.gotAck = false;
        for (int i = 0; i < 2; ++i) {
            buffer[i] = this.ackPacket[i];
        }
        return 2;
    }

    private void getOp() {
        while (true) {
            byte[] b;
            int r;
            if ((r = tower.read(b = new byte[1], 100)) <= 0) {
                long currTime;
                if (this.usbFlag == 0 && this.listen && (currTime = System.currentTimeMillis()) - this.sendTime >= 3000L) {
                    if (this.debug) {
                        System.out.println("Sending keep-alive");
                    }
                    tower.write(this.keepAlive, 1);
                    tower.read(this.trash, 100);
                    this.sendTime = currTime;
                }
                return;
            }
            this.op = b[0];
            if ((this.op & 0xF7) == 241) {
                this.gotPacket = true;
                this.inPacket[0] = this.op;
                int extra = (this.op & 7) + 1;
                byte[] rest = new byte[extra];
                r = tower.read(rest, 100);
                for (int i = 0; i < r; ++i) {
                    this.inPacket[i + 1] = rest[i];
                }
                this.inPacketLength = extra + 1;
                return;
            }
            if ((this.op & 0xF7) == 240) {
                this.gotAck = true;
                this.ackPacket[0] = this.op;
                byte[] rest = new byte[1];
                r = tower.read(rest, 100);
                this.ackPacket[1] = rest[0];
                return;
            }
            if (!this.debug) continue;
            System.out.println("Discarding " + this.op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPacketAvailable() {
        LLCHandler lLCHandler = this;
        synchronized (lLCHandler) {
            if (this.gotPacket) {
                return true;
            }
            this.getOp();
            return this.gotPacket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAckAvailable() {
        LLCHandler lLCHandler = this;
        synchronized (lLCHandler) {
            if (this.gotAck) {
                return true;
            }
            this.getOp();
            return this.gotAck;
        }
    }

    public void close() {
        tower.close();
        this.open = false;
    }
}

