/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import josx.rcxcomm.RCXPort;

public class HttpProxy {
    private boolean busy = false;

    public HttpProxy(int httpPort, String towerPort) throws IOException {
        ServerSocket serverSock = new ServerSocket(httpPort);
        while (true) {
            System.out.println("Waiting for request on httpPort " + httpPort);
            Socket sock = serverSock.accept();
            System.out.println("Received request");
            if (this.busy) {
                System.out.println("RCX is busy");
                BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                in.readLine();
                PrintWriter pw = new PrintWriter(sock.getOutputStream());
                pw.println("HTTP/1.0 200");
                pw.println("Content-Type: text/html");
                pw.println();
                pw.println("<HTML><BODY>RCX is Busy</BODY></HTML>");
                pw.close();
                continue;
            }
            this.setBusy(true);
            RCXThread rcxThread = new RCXThread(this, sock, towerPort);
            rcxThread.start();
        }
    }

    synchronized void setBusy(boolean busy) {
        this.busy = busy;
    }

    public static void main(String[] args) throws IOException {
        int httpPort = 80;
        String towerPort = "USB";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-httpPort")) {
                if (i < args.length - 1) {
                    httpPort = Integer.parseInt(args[i + 1]);
                }
                ++i;
            }
            if (!args[i].equals("-towerPort")) continue;
            if (i < args.length - 1) {
                towerPort = args[i + 1];
            }
            ++i;
        }
        new HttpProxy(httpPort, towerPort);
    }

    class RCXThread
    extends Thread {
        private Socket sock;
        private HttpProxy proxy;
        private String towerPort;

        RCXThread(HttpProxy proxy, Socket sock, String towerPort) {
            this.sock = sock;
            this.proxy = proxy;
        }

        public void run() {
            try {
                int inb;
                RCXPort httpPort = new RCXPort(this.towerPort);
                InputStream is = httpPort.getInputStream();
                OutputStream os = httpPort.getOutputStream();
                InputStream in = this.sock.getInputStream();
                OutputStream out = this.sock.getOutputStream();
                byte b = 0;
                byte lastB = 0;
                byte lastB2 = 0;
                byte lastB3 = 0;
                do {
                    lastB = b;
                    b = (byte)in.read();
                    System.out.println("Input Stream: " + (char)b);
                    os.write(b);
                } while (b != 10 || lastB != 13);
                os.write(13);
                os.write(10);
                System.out.println("Skipping headers");
                do {
                    lastB3 = lastB2;
                    lastB2 = lastB;
                    lastB = b;
                } while ((b = (byte)in.read()) != 10 || lastB != 13 || lastB2 != 10 || lastB3 != 13);
                do {
                    if ((inb = is.read()) == 255) {
                        out.flush();
                        this.sock.close();
                        System.out.println("Socket closed");
                        continue;
                    }
                    System.out.println("Output Stream: " + (char)inb);
                    out.write(inb);
                } while (inb != 255);
                httpPort.close();
                this.proxy.setBusy(false);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

