/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.PacketHandler;
import josx.rcxcomm.Tower;
import josx.rcxcomm.TowerException;

public class F7Handler
extends PacketHandler {
    private byte[] f7pack = new byte[]{-9, 0};
    private byte[] trash = new byte[1];
    private byte[] keepAlive = new byte[]{-1};
    private Tower tower;
    private byte[] buffer = new byte[9];
    private int usbFlag;
    private int bytesRead = 0;
    private long sendTime;
    private boolean listen = false;
    boolean debug = false;

    F7Handler(String port) {
        try {
            this.tower = new Tower(port);
            this.tower.openTower(false);
            this.usbFlag = this.tower.isUSB() ? 1 : 0;
        }
        catch (TowerException e) {
            e.printStackTrace();
        }
    }

    public int getError() {
        return this.tower.getError();
    }

    public void setListen(boolean listen) {
        this.listen = listen;
    }

    public boolean sendPacket(byte[] packet, int len) {
        if (this.debug) {
            System.out.println("Sending " + packet[0]);
        }
        this.f7pack[1] = packet[0];
        this.sendTime = System.currentTimeMillis();
        return this.tower.send(this.f7pack, 2) == 2;
    }

    public int receivePacket(byte[] packet) {
        int start;
        int i;
        if (this.debug) {
            String s = "Read";
            for (i = 0; i < this.bytesRead; ++i) {
                s = s + " " + this.buffer[i];
            }
            System.out.println(s);
        }
        int n = start = this.buffer[0] == 85 ? 1 : 0;
        if (this.bytesRead - start < 8) {
            if (this.debug) {
                System.out.println("Packet too short");
            }
            this.bytesRead = 0;
            return 0;
        }
        for (i = start; i < this.bytesRead - 1; i += 2) {
            if (this.buffer[i] == ~this.buffer[i + 1]) continue;
            return -1;
        }
        this.bytesRead = 0;
        if (this.buffer[start] != -1 || this.buffer[start + 2] != -9) {
            return -1;
        }
        packet[0] = this.buffer[start + 2];
        packet[1] = this.buffer[start + 4];
        if (this.debug) {
            System.out.println("Read " + packet[1]);
        }
        return 2;
    }

    public boolean isPacketAvailable() {
        long currTime;
        if (this.bytesRead > 0) {
            return true;
        }
        this.bytesRead = this.tower.read(this.buffer, 100);
        if (this.usbFlag == 0 && this.listen && this.bytesRead == 0 && (currTime = System.currentTimeMillis()) - this.sendTime >= 3000L) {
            if (this.debug) {
                System.out.println("Sending keep-alive");
            }
            this.tower.write(this.keepAlive, 1);
            this.tower.read(this.trash, 100);
            this.sendTime = currTime;
        }
        boolean r = this.bytesRead > 0;
        return r;
    }

    public void close() {
        this.tower.close();
    }
}

