/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm.remotecontrol;

import java.util.Vector;
import josx.platform.rcx.Motor;
import josx.platform.rcx.Opcode;
import josx.platform.rcx.Serial;
import josx.platform.rcx.SerialListener;
import josx.platform.rcx.Sound;
import josx.rcxcomm.remotecontrol.RemoteControlListener;

public class RemoteControlSensor
implements SerialListener,
Opcode {
    private static final byte F7_OPCODE = -9;
    private byte[] fF7AckPacket = new byte[]{-9, 0};
    private byte[] fF7Buffer = new byte[]{0, 0};
    private int fF7Counter = 0;
    private Vector fListeners = new Vector(2, 2);

    public RemoteControlSensor() {
        Serial.addSerialListener((SerialListener)this);
    }

    public void addRemoteControlListener(RemoteControlListener aListener) {
        this.fListeners.addElement(aListener);
    }

    public void removeRemoteControlListener(RemoteControlListener aListener) {
        this.fListeners.removeElement(aListener);
    }

    public void packetAvailable(byte[] aPacket, int aLength) {
        if (aLength < 3) {
            return;
        }
        int opcode = 0;
        byte protocol = aPacket[0];
        if (protocol == -9) {
            this.fF7Buffer[this.fF7Counter] = aPacket[1];
            if (!this.acknowledgeF7(aPacket)) {
                Sound.buzz();
                return;
            }
            ++this.fF7Counter;
            if (this.fF7Counter < 2) {
                return;
            }
            this.fF7Counter = 0;
            opcode = (this.fF7Buffer[0] & 0xFF) * 256 + (this.fF7Buffer[1] & 0xFF);
        } else if ((protocol & 0xFF) == 210) {
            opcode = (aPacket[1] & 0xFF) * 256 + (aPacket[2] & 0xFF);
        } else {
            return;
        }
        this.inspect(opcode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acknowledgeF7(byte[] anIncomingPacket) {
        RemoteControlSensor remoteControlSensor = this;
        synchronized (remoteControlSensor) {
            byte incoming = anIncomingPacket[1];
            this.fF7AckPacket[1] = ~incoming;
            while (Serial.isSending()) {
                Thread.yield();
            }
            return Serial.sendPacket((byte[])this.fF7AckPacket, (int)0, (int)2);
        }
    }

    private void inspect(int anOpcode) {
        if (anOpcode == 1) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).message1Pressed();
            }
        } else if (anOpcode == 2) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).message2Pressed();
            }
        } else if (anOpcode == 4) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).message3Pressed();
            }
        } else if (anOpcode == 8) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).motorUpPressed(Motor.A);
            }
        } else if (anOpcode == 16) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).motorUpPressed(Motor.B);
            }
        } else if (anOpcode == 32) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).motorUpPressed(Motor.C);
            }
        } else if (anOpcode == 64) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).motorDownPressed(Motor.A);
            }
        } else if (anOpcode == 128) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).motorDownPressed(Motor.B);
            }
        } else if (anOpcode == 256) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).motorDownPressed(Motor.C);
            }
        } else if (anOpcode == 512) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).program1Pressed();
            }
        } else if (anOpcode == 1024) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).program2Pressed();
            }
        } else if (anOpcode == 2048) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).program3Pressed();
            }
        } else if (anOpcode == 4096) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).program4Pressed();
            }
        } else if (anOpcode == 8192) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).program5Pressed();
            }
        } else if (anOpcode == 16384) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).stopPressed();
            }
        } else if (anOpcode == 32768) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                ((RemoteControlListener)this.fListeners.elementAt(i)).soundPressed();
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

