/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import java.io.IOException;
import java.io.InputStream;
import josx.rcxcomm.LLCHandler;
import josx.rcxcomm.LLCReliableHandler;
import josx.rcxcomm.PacketHandler;

public class RCXInputStream
extends InputStream {
    public static final int DEFAULT_BUFFER_SIZE = 32;
    public static final int DEFAULT_TIMEOUT = 0;
    private int bufferSize = 32;
    private byte[] buffer;
    private int current = 0;
    private int last = 0;
    private int time1;
    private IOException ioe;
    private Listener listener;
    private boolean portOpen = true;
    private int timeout = 0;
    private PacketHandler packetHandler;
    private byte[] inPacket = new byte[2];

    public RCXInputStream() {
        this.packetHandler = new LLCReliableHandler(new LLCHandler());
        this.buffer = new byte[this.bufferSize];
        this.ioe = new IOException();
        this.listener = new Listener();
        this.listener.setDaemon(true);
        this.listener.start();
    }

    public void setTimeOut(int timeout) {
        this.timeout = timeout;
    }

    public int available() throws IOException {
        if (this.last < this.current) {
            return this.bufferSize - (this.current - this.last);
        }
        return this.last - this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read() throws IOException {
        this.time1 = (int)System.currentTimeMillis();
        while (this.available() == 0) {
            if (this.timeout != 0 && (int)System.currentTimeMillis() - this.time1 > this.timeout) {
                throw this.ioe;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int b = this.buffer[this.current++];
            if (this.current == this.bufferSize) {
                this.current = 0;
            }
            if (b < 0) {
                b += 256;
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(byte b) {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.buffer[this.last++] = b;
            if (this.last == this.bufferSize) {
                this.last = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void close() {
        this.portOpen = false;
    }

    private class Listener
    extends Thread {
        private Listener() {
        }

        public void run() {
            while (RCXInputStream.this.portOpen) {
                if (RCXInputStream.this.packetHandler.isPacketAvailable()) {
                    int r = RCXInputStream.this.packetHandler.receivePacket(RCXInputStream.this.inPacket);
                    for (int i = 0; i < r; ++i) {
                        RCXInputStream.this.add(RCXInputStream.this.inPacket[i]);
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

