/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.LLC;
import josx.rcxcomm.PacketHandler;

public class LNPHandler
extends PacketHandler {
    private byte op;
    private boolean gotPacket = false;
    private byte[] inPacket = new byte[259];
    private int inPacketLength;
    private boolean isAddressing;

    public LNPHandler() {
        LLC.init();
    }

    public boolean isAddressing() {
        return this.isAddressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPacket(byte[] packet, int len) {
        LNPHandler lNPHandler = this;
        synchronized (lNPHandler) {
            return LLC.sendBytes(packet, len);
        }
    }

    public int receivePacket(byte[] buffer) {
        this.gotPacket = false;
        for (int i = 0; i < this.inPacketLength; ++i) {
            buffer[i] = this.inPacket[i];
        }
        return this.inPacketLength;
    }

    private void getOp() {
        do {
            int r;
            if ((r = LLC.read()) < 0) {
                return;
            }
            this.op = (byte)r;
        } while (this.op != -16 && this.op != -15);
        int len = LLC.receive();
        if (len < 0) {
            return;
        }
        this.gotPacket = true;
        this.isAddressing = this.op == -15;
        this.inPacket[0] = this.op;
        this.inPacket[1] = (byte)len;
        int extra = (len & 0xFF) + 1;
        for (int i = 0; i < extra; ++i) {
            this.inPacket[i + 2] = (byte)LLC.receive();
        }
        this.inPacketLength = extra + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPacketAvailable() {
        LNPHandler lNPHandler = this;
        synchronized (lNPHandler) {
            if (this.gotPacket) {
                return true;
            }
            this.getOp();
            return this.gotPacket;
        }
    }
}

