/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.PacketHandler;

public class LNPAddressingHandler
extends PacketHandler {
    private byte[] inPacket = new byte[259];
    private byte[] outPacket = new byte[259];
    private int inPacketLength = 0;
    private byte source;
    private byte dest;

    public LNPAddressingHandler(PacketHandler handler) {
        super(handler);
    }

    public void open(byte source, byte destination) {
        this.source = source;
        this.dest = destination;
    }

    public boolean sendPacket(byte[] packet, int len) {
        this.outPacket[0] = this.dest;
        this.outPacket[1] = this.source;
        for (int i = 0; i < len; ++i) {
            this.outPacket[i + 2] = packet[i];
        }
        return this.lowerHandler.sendPacket(this.outPacket, len + 2);
    }

    public int receivePacket(byte[] buffer) {
        int temp = this.inPacketLength;
        for (int i = 0; i < temp; ++i) {
            buffer[i] = this.inPacket[i + 2];
        }
        this.inPacketLength = 0;
        return temp;
    }

    public boolean isPacketAvailable() {
        if (this.inPacketLength > 0) {
            return true;
        }
        while (this.lowerHandler.isPacketAvailable()) {
            int len = this.lowerHandler.receivePacket(this.inPacket);
            if (this.source != this.inPacket[0] || this.dest != this.inPacket[1]) continue;
            this.inPacketLength = len - 2;
            return true;
        }
        return false;
    }
}

