/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.platform.rcx.ROM;

public class LLC {
    private static int sendTime;
    private static final int COLLISION_DELAY = 200;

    private LLC() {
    }

    public static native void init();

    public static native int read();

    private static native void write(byte[] var0, int var1);

    public static native boolean isSending();

    public static native boolean isSendError();

    public static boolean sendBytes(byte[] buf, int len) {
        if (LLC.isSending()) {
            return false;
        }
        int currTime = (int)System.currentTimeMillis();
        if (LLC.isSendError() && currTime - sendTime < 200) {
            try {
                Thread.sleep(200 - (currTime - sendTime));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        sendTime = (int)System.currentTimeMillis();
        LLC.write(buf, len);
        while (LLC.isSending()) {
            Thread.yield();
        }
        return !LLC.isSendError();
    }

    public static int receive() {
        for (int i = 0; i < 10; ++i) {
            int r = LLC.read();
            if (r >= 0) {
                return r;
            }
            Thread.yield();
        }
        return -1;
    }

    public static void setRangeLong() {
        ROM.call((short)12880, (short)6000);
    }

    public static void setRangeShort() {
        ROM.call((short)12902, (short)6000);
    }
}

