/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

public class HttpServletRequest {
    private String path;
    private int pathLength;
    private String queryString;
    private int queryStringLength;
    private static final int MAX_PARAM = 16;
    private char[] tempChars = new char[16];
    private String param = new String(this.tempChars, 0, 16);
    private char[] paramChars = StringUtils.getCharacters((String)this.param);
    private int paramLength = 0;

    void setPath(String path, int pathLength) {
        this.path = path;
        this.pathLength = pathLength;
    }

    void setQueryString(String queryString, int queryStringLength) {
        this.queryString = queryString;
        this.queryStringLength = queryStringLength;
    }

    public String getServletPath() {
        return this.path;
    }

    public String getRequestURI() {
        return this.path;
    }

    public int getServletPathLength() {
        return this.pathLength;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int getQueryStringLength() {
        return this.queryStringLength;
    }

    public String getParameter(String name) {
        char[] nameChars = StringUtils.getCharacters((String)name);
        char[] queryStringChars = StringUtils.getCharacters((String)this.queryString);
        for (int i = 0; i < this.queryStringLength - nameChars.length - 2; ++i) {
            int j;
            if (i != 0 && queryStringChars[i - 1] != '&') continue;
            for (j = 0; j < nameChars.length && queryStringChars[i + j] == nameChars[j]; ++j) {
            }
            if (j != nameChars.length || queryStringChars[j + i] != '=') continue;
            int valueStart = i + j + 1;
            this.paramLength = 0;
            while (valueStart + this.paramLength < this.queryStringLength && queryStringChars[valueStart + this.paramLength] != '&' && this.paramLength != 16) {
                this.paramChars[this.paramLength] = queryStringChars[valueStart + this.paramLength];
                ++this.paramLength;
            }
            for (j = this.paramLength; j < 16; ++j) {
                this.paramChars[j] = 32;
            }
            return this.param;
        }
        return null;
    }

    public int getParameterLength() {
        return this.paramLength;
    }
}

