/*
 * Decompiled with CFR 0.152.
 */
package josx.robotics;

import josx.platform.rcx.Motor;
import josx.robotics.Navigator;

public class TimingNavigator
implements Navigator {
    private float ROTATION;
    private float CENTIMETER;
    private float angle;
    private float x;
    private float y;
    private int oldTime;
    private Motor left;
    private Motor right;
    private static Thread sleepThread;
    private boolean travel = false;
    private short momentum_delay = 0;

    public TimingNavigator(Motor right, Motor left, float timeOneMeter, float timeRotate) {
        this.right = right;
        this.left = left;
        this.ROTATION = timeRotate / 360.0f * 1000.0f;
        this.CENTIMETER = timeOneMeter / 100.0f * 1000.0f;
        this.angle = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public void setMomentumDelay(short delay) {
        this.momentum_delay = delay;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }

    public void rotate(float angle) {
        this.angle += angle;
        this.angle = (int)this.angle % 360;
        if (this.angle < 0.0f) {
            this.angle += 360.0f;
        }
        this.oldTime = (int)System.currentTimeMillis();
        int delay = (int)((double)this.ROTATION * Math.abs(angle)) + this.momentum_delay;
        if (angle > 0.0f) {
            this.right.forward();
            this.left.backward();
        } else if (angle < 0.0f) {
            this.left.forward();
            this.right.backward();
            angle *= -1.0f;
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.right.stop();
        this.left.stop();
    }

    public void gotoAngle(float angle) {
        float difference;
        for (difference = angle - this.angle; difference > 180.0f; difference -= 360.0f) {
        }
        while (difference < -180.0f) {
            difference += 360.0f;
        }
        this.rotate(difference);
    }

    public void gotoPoint(float x, float y) {
        float x1 = x - this.x;
        float y1 = y - this.y;
        float angle = (float)Math.atan2(y1, x1);
        float distance = y1 != 0.0f ? y1 / (float)Math.sin(angle) : x1 / (float)Math.cos(angle);
        angle = (float)Math.toDegrees(angle);
        this.gotoAngle(angle);
        this.travel(Math.round(distance));
    }

    public void travel(int distance) {
        if (distance > 0) {
            this.forward();
        } else {
            this.backward();
        }
        this.travel = true;
        int delay = (int)(this.CENTIMETER * (float)Math.abs(distance));
        sleepThread = Thread.currentThread();
        try {
            Thread.sleep(delay);
            this.travel = false;
            this.stop();
        }
        catch (InterruptedException ie) {
            this.travel = false;
        }
    }

    public void forward() {
        this.oldTime = (int)System.currentTimeMillis();
        this.right.forward();
        this.left.forward();
    }

    public void backward() {
        this.oldTime = (int)System.currentTimeMillis();
        this.right.backward();
        this.left.backward();
    }

    public void stop() {
        if (this.travel) {
            sleepThread.interrupt();
        }
        this.left.stop();
        this.right.stop();
        if (this.oldTime != 0) {
            int totalTime = (int)System.currentTimeMillis() - this.oldTime;
            float centimeters = (float)totalTime / this.CENTIMETER;
            this.x += (float)(Math.cos(Math.toRadians(this.angle)) * (double)centimeters);
            this.y += (float)(Math.sin(Math.toRadians(this.angle)) * (double)centimeters);
            this.oldTime = 0;
        }
    }
}

