/*
 * Decompiled with CFR 0.152.
 */
package josx.robotics;

import josx.platform.rcx.Motor;
import josx.platform.rcx.Sensor;
import josx.platform.rcx.SensorConstants;
import josx.robotics.Navigator;

public class RotationNavigator
implements Navigator,
SensorConstants {
    private float angle;
    private float x;
    private float y;
    private Motor left;
    private Motor right;
    private Sensor rotLeft;
    private Sensor rotRight;
    private float COUNTS_PER_CM;
    private float COUNTS_PER_DEGREE;
    private boolean moving;
    private byte command;
    private byte STOP = 0;
    private byte FORWARD = 1;
    private byte BACKWARD = (byte)2;
    private byte LEFT_ROTATE = (byte)3;
    private byte RIGHT_ROTATE = (byte)4;

    public RotationNavigator(float wheelDiameter, float driveLength, float ratio, Motor leftMotor, Motor rightMotor, Sensor leftRot, Sensor rightRot) {
        this.right = rightMotor;
        this.left = leftMotor;
        this.rotLeft = leftRot;
        this.rotLeft.setTypeAndMode(4, 224);
        this.rotLeft.setPreviousValue(0);
        this.rotLeft.activate();
        this.rotRight = rightRot;
        this.rotRight.setTypeAndMode(4, 224);
        this.rotRight.setPreviousValue(0);
        this.rotRight.activate();
        this.angle = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.moving = false;
        this.command = this.STOP;
        float wheelCircumference = wheelDiameter * (float)Math.PI;
        this.COUNTS_PER_CM = 16.0f * ratio / wheelCircumference;
        float fullRotation = driveLength * (float)Math.PI;
        this.COUNTS_PER_DEGREE = fullRotation / wheelCircumference * (16.0f * ratio) / 360.0f;
        SteerThread steering = new SteerThread();
        steering.start();
    }

    public RotationNavigator(float wheelDiameter, float driveLength, float ratio) {
        this(wheelDiameter, driveLength, ratio, Motor.A, Motor.C, Sensor.S1, Sensor.S3);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }

    public void rotate(float angle) {
        this.angle += angle;
        this.angle = (int)this.angle % 360;
        while (this.angle < 0.0f) {
            this.angle += 360.0f;
        }
        int count = (int)(this.COUNTS_PER_DEGREE * angle);
        this.rotLeft.setPreviousValue(0);
        this.rotRight.setPreviousValue(0);
        if (angle > 0.0f) {
            this.right.forward();
            this.left.backward();
            while (this.rotLeft.readValue() > count * -1 || this.rotRight.readValue() < count) {
            }
        } else if (angle < 0.0f) {
            this.right.backward();
            this.left.forward();
            while (this.rotLeft.readValue() < count * -1 || this.rotRight.readValue() > count) {
            }
        }
        this.right.stop();
        this.left.stop();
    }

    public void gotoAngle(float angle) {
        float difference;
        for (difference = angle - this.angle; difference > 180.0f; difference -= 360.0f) {
        }
        while (difference < -180.0f) {
            difference += 360.0f;
        }
        this.rotate(difference);
    }

    public void gotoPoint(float x, float y) {
        float x1 = x - this.x;
        float y1 = y - this.y;
        float angle = (float)Math.atan2(y1, x1);
        float distance = y1 != 0.0f ? y1 / (float)Math.sin(angle) : x1 / (float)Math.cos(angle);
        angle = (float)Math.toDegrees(angle);
        this.gotoAngle(angle);
        this.travel(Math.round(distance));
    }

    public void travel(int dist) {
        int counts = (int)((float)dist * this.COUNTS_PER_CM);
        if (dist > 0) {
            this.forward();
            while (this.command != this.STOP && (this.rotLeft.readValue() < counts || this.rotRight.readValue() < counts)) {
                Thread.yield();
            }
        } else if (dist < 0) {
            this.backward();
            while (this.command != this.STOP && this.rotLeft.readValue() > counts || this.rotRight.readValue() > counts) {
                Thread.yield();
            }
        }
        this.stop();
    }

    public void forward() {
        this.rotLeft.setPreviousValue(0);
        this.rotRight.setPreviousValue(0);
        this.command = this.FORWARD;
    }

    public void backward() {
        this.rotLeft.setPreviousValue(0);
        this.rotRight.setPreviousValue(0);
        this.command = this.BACKWARD;
    }

    public void stop() {
        if (this.moving) {
            this.command = this.STOP;
            while (this.moving) {
                Thread.yield();
            }
            this.left.stop();
            this.right.stop();
            int rotAvg = (this.rotLeft.readValue() + this.rotRight.readValue()) / 2;
            float centimeters = (float)rotAvg / this.COUNTS_PER_CM;
            this.x += (float)(Math.cos(Math.toRadians(this.angle)) * (double)centimeters);
            this.y += (float)(Math.sin(Math.toRadians(this.angle)) * (double)centimeters);
        }
    }

    private class SteerThread
    extends Thread {
        private SteerThread() {
        }

        public void run() {
            while (true) {
                if (RotationNavigator.this.command == RotationNavigator.this.FORWARD) {
                    RotationNavigator.this.left.forward();
                    RotationNavigator.this.right.forward();
                    RotationNavigator.this.moving = true;
                    if (RotationNavigator.this.rotLeft.readValue() > RotationNavigator.this.rotRight.readValue()) {
                        RotationNavigator.this.left.flt();
                        while (RotationNavigator.this.rotLeft.readValue() > RotationNavigator.this.rotRight.readValue()) {
                        }
                        RotationNavigator.this.left.forward();
                    }
                    if (RotationNavigator.this.rotRight.readValue() > RotationNavigator.this.rotLeft.readValue()) {
                        RotationNavigator.this.right.flt();
                        while (RotationNavigator.this.rotRight.readValue() > RotationNavigator.this.rotLeft.readValue()) {
                        }
                        RotationNavigator.this.right.forward();
                    }
                    Thread.yield();
                    continue;
                }
                while (RotationNavigator.this.command == RotationNavigator.this.BACKWARD) {
                    RotationNavigator.this.left.backward();
                    RotationNavigator.this.right.backward();
                    RotationNavigator.this.moving = true;
                    if (RotationNavigator.this.rotLeft.readValue() < RotationNavigator.this.rotRight.readValue()) {
                        RotationNavigator.this.left.flt();
                        while (RotationNavigator.this.rotLeft.readValue() < RotationNavigator.this.rotRight.readValue()) {
                        }
                        RotationNavigator.this.left.backward();
                    }
                    if (RotationNavigator.this.rotRight.readValue() < RotationNavigator.this.rotLeft.readValue()) {
                        RotationNavigator.this.right.flt();
                        while (RotationNavigator.this.rotRight.readValue() < RotationNavigator.this.rotLeft.readValue()) {
                        }
                        RotationNavigator.this.right.backward();
                    }
                    Thread.yield();
                }
                RotationNavigator.this.moving = false;
                Thread.yield();
            }
        }
    }
}

