/*
 * Decompiled with CFR 0.152.
 */
package josx.robotics;

import josx.robotics.Behavior;

public class Arbitrator {
    private Behavior[] behavior;
    private final int NONE = 99;
    private int currentBehavior;
    private BehaviorAction actionThread;

    public Arbitrator(Behavior[] behaviors) {
        this.behavior = behaviors;
        this.currentBehavior = 99;
        this.actionThread = new BehaviorAction();
        this.actionThread.start();
    }

    public void start() {
        int totalBehaviors = this.behavior.length - 1;
        block0: while (true) {
            int i = totalBehaviors;
            while (true) {
                if (i < 0) continue block0;
                if (this.behavior[i].takeControl()) {
                    if (i == this.currentBehavior) continue block0;
                    if (this.currentBehavior != 99) {
                        if (this.currentBehavior >= i) {
                            while (!this.actionThread.done) {
                                Thread.yield();
                            }
                        }
                        this.behavior[this.currentBehavior].suppress();
                    }
                    this.currentBehavior = i;
                    this.actionThread.execute(i);
                    Thread.yield();
                    continue block0;
                }
                --i;
            }
            break;
        }
    }

    private class BehaviorAction
    extends Thread {
        public boolean done = true;
        int current = 99;

        private BehaviorAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                BehaviorAction behaviorAction = this;
                synchronized (behaviorAction) {
                    if (this.current != 99) {
                        this.done = false;
                        Arbitrator.this.behavior[this.current].action();
                        this.current = 99;
                        this.done = true;
                    }
                }
                Thread.yield();
            }
        }

        public synchronized void execute(int index) {
            this.current = index;
        }
    }
}

