/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.LCD;
import josx.platform.rcx.Memory;

public class TextLCD {
    private static final byte[] ascii_display_codes = new byte[]{0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 66, 10, 123, 109, 19, 125, 8, 60, 102, 91, 67, 16, 1, 16, 19, 126, 66, 55, 103, 75, 109, 125, 70, 127, 111, 33, 33, 49, 33, 97, 23, 63, 95, 121, 60, 115, 61, 29, 124, 91, 66, 98, 91, 56, 94, 94, 126, 31, 79, 17, 109, 70, 122, 122, 122, 91, 107, 55, 60, 73, 102, 14, 32, 2, 95, 121, 49, 115, 61, 29, 124, 89, 66, 98, 91, 56, 81, 81, 113, 31, 79, 17, 109, 57, 112, 112, 112, 91, 107, 55, 60, 24, 102, 14, 0};

    private TextLCD() {
    }

    public static final void print(String str) {
        TextLCD.print(StringUtils.getCharacters(str));
    }

    public static final void print(char[] text) {
        int i;
        for (i = 0; i < text.length && i <= 4; ++i) {
            TextLCD.printChar(text[i], 4 - i);
        }
        while (i <= 4) {
            TextLCD.printChar('\u0000', 4 - i++);
        }
        LCD.refresh();
    }

    public static final void printChar(char the_char, int pos) {
        if (pos == 0) {
            TextLCD.native_print_pos_0(ascii_display_codes[the_char]);
        } else if (pos == 1) {
            TextLCD.native_print_pos_1(ascii_display_codes[the_char]);
        } else if (pos == 2) {
            TextLCD.native_print_pos_2(ascii_display_codes[the_char]);
        } else if (pos == 3) {
            TextLCD.native_print_pos_3(ascii_display_codes[the_char]);
        } else if (pos == 4) {
            TextLCD.native_print_pos_4(ascii_display_codes[the_char]);
        }
    }

    private static final void native_print_pos_0(byte mask) {
        Memory.setBit(61252, 4, mask & 4);
        Memory.setBit(61252, 5, mask & 1);
        Memory.setBit(61252, 7, mask & 0x20);
        Memory.setBit(61253, 5, mask & 2);
        Memory.setBit(61253, 7, mask & 0x40);
        Memory.setBit(61255, 5, mask & 8);
        Memory.setBit(61255, 7, mask & 0x10);
    }

    private static final void native_print_pos_1(byte mask) {
        Memory.setBit(61251, 4, mask & 4);
        Memory.setBit(61251, 5, mask & 1);
        Memory.setBit(61251, 7, mask & 0x20);
        Memory.setBit(61255, 1, mask & 2);
        Memory.setBit(61255, 3, mask & 0x40);
        Memory.setBit(61256, 5, mask & 8);
        Memory.setBit(61256, 7, mask & 0x10);
    }

    private static final void native_print_pos_2(byte mask) {
        Memory.setBit(61252, 0, mask & 4);
        Memory.setBit(61252, 1, mask & 1);
        Memory.setBit(61252, 3, mask & 0x20);
        Memory.setBit(61256, 1, mask & 2);
        Memory.setBit(61256, 3, mask & 0x40);
        Memory.setBit(61257, 5, mask & 8);
        Memory.setBit(61257, 7, mask & 0x10);
    }

    private static final void native_print_pos_3(byte mask) {
        Memory.setBit(61254, 0, mask & 4);
        Memory.setBit(61254, 1, mask & 1);
        Memory.setBit(61254, 3, mask & 0x20);
        Memory.setBit(61259, 1, mask & 2);
        Memory.setBit(61259, 3, mask & 0x40);
        Memory.setBit(61259, 5, mask & 8);
        Memory.setBit(61259, 7, mask & 0x10);
    }

    private static final void native_print_pos_4(byte mask) {
        Memory.setBit(61254, 4, mask & 4);
        Memory.setBit(61254, 5, mask & 1);
        Memory.setBit(61254, 7, mask & 0x20);
        Memory.setBit(61258, 1, mask & 2);
        Memory.setBit(61258, 3, mask & 0x40);
        Memory.setBit(61258, 5, mask & 8);
        Memory.setBit(61258, 7, mask & 0x10);
    }
}

