/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.Motor;
import josx.platform.rcx.Sensor;
import josx.platform.rcx.SensorListener;

public class Servo
implements SensorListener {
    Sensor sensor;
    Motor motor;
    int position;
    int targetPosition;
    int slack;

    public Servo(Sensor sensor, Motor motor, int slack) {
        this.sensor = sensor;
        this.motor = motor;
        this.slack = slack;
        this.targetPosition = 0;
        this.position = 0;
        sensor.addSensorListener(this);
        sensor.setTypeAndMode(4, 224);
        sensor.setPreviousValue(0);
        sensor.activate();
    }

    public Servo(Sensor sensor, Motor motor) {
        this(sensor, motor, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rotateTo(int pos) {
        Servo servo = this;
        synchronized (servo) {
            boolean ret = false;
            this.targetPosition = pos;
            int diff = this.targetPosition - this.position;
            this.motor.setPower(7);
            if (diff < this.slack) {
                this.motor.forward();
            } else if (diff > this.slack) {
                this.motor.backward();
            } else {
                ret = true;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(Sensor sensor, int oldValue, int newValue) {
        Servo servo = this;
        synchronized (servo) {
            this.position = newValue;
            int diff = this.targetPosition - this.position;
            if (diff >= -this.slack && diff <= this.slack) {
                this.motor.stop();
                this.notifyAll();
            }
        }
    }
}

