/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.ListenerCaller;
import josx.platform.rcx.ListenerThread;
import josx.platform.rcx.Memory;
import josx.platform.rcx.ROM;
import josx.platform.rcx.SerialListener;

public class Serial {
    static final byte[] buffer = new byte[6];
    private static final byte[] iAuxBuffer = new byte[4];
    private static final int iAuxBufferAddr = Memory.getDataAddress(iAuxBuffer);
    private static SerialListener[] iListeners = null;
    private static int iNumListeners;
    private static SerialListenerCaller singleton;

    private Serial() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readPacket(byte[] aBuffer) {
        Object object = Memory.MONITOR;
        synchronized (object) {
            Serial.iAuxBuffer[2] = 0;
            ROM.call((short)13232, (short)Memory.getDataAddress(aBuffer), (short)aBuffer.length, (short)(iAuxBufferAddr + 2));
            return iAuxBuffer[2];
        }
    }

    public static void setDataBuffer(byte[] aData) {
        ROM.call((short)12924, (short)6001, (short)Memory.getDataAddress(aData), (short)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPacketAvailable() {
        Object object = Memory.MONITOR;
        synchronized (object) {
            ROM.call((short)13350, (short)(iAuxBufferAddr + 3), (short)0);
            return iAuxBuffer[3] != 0;
        }
    }

    public static boolean sendPacket(byte[] aBuffer, int aOffset, int aLen) {
        if (Serial.isSending()) {
            return false;
        }
        ROM.call((short)13374, (short)6005, (short)0, (short)(Memory.getDataAddress(aBuffer) + aOffset), (short)aLen);
        return true;
    }

    public static void setRangeLong() {
        ROM.call((short)12880, (short)6000);
    }

    public static void setRangeShort() {
        ROM.call((short)12902, (short)6000);
    }

    public static native void resetSerial();

    public static boolean isSending() {
        return Memory.readByte(61331) != 79;
    }

    public static void waitTillSent() throws InterruptedException {
        while (Serial.isSending()) {
            Thread.sleep(20L);
        }
    }

    public static synchronized void addSerialListener(SerialListener aListener) {
        if (iListeners == null) {
            iListeners = new SerialListener[4];
            singleton = new SerialListenerCaller();
        }
        Serial.iListeners[Serial.iNumListeners++] = aListener;
        ListenerThread.get().addSerialToMask(singleton);
    }

    private static class SerialListenerCaller
    implements ListenerCaller {
        private SerialListenerCaller() {
        }

        public synchronized void callListeners() {
            int length = Serial.readPacket(buffer);
            for (int i = 0; i < iNumListeners; ++i) {
                iListeners[i].packetAvailable(buffer, length);
            }
        }
    }
}

