/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.ListenerCaller;
import josx.platform.rcx.ListenerThread;
import josx.platform.rcx.ROM;
import josx.platform.rcx.SensorListener;

public class Sensor
implements ListenerCaller {
    private int iSensorId;
    private short iNumListeners = 0;
    private SensorListener[] iListeners;
    private int iPreviousValue;
    public static final Sensor S1 = new Sensor(0);
    public static final Sensor S2 = new Sensor(1);
    public static final Sensor S3 = new Sensor(2);
    public static final Sensor[] SENSORS = new Sensor[]{S1, S2, S3};

    public final int readValue() {
        return Sensor.readSensorValue(this.iSensorId, 1);
    }

    public final int readRawValue() {
        return Sensor.readSensorValue(this.iSensorId, 0);
    }

    public final boolean readBooleanValue() {
        return Sensor.readSensorValue(this.iSensorId, 2) != 0;
    }

    private Sensor(int aId) {
        this.iSensorId = aId;
        this.setTypeAndMode(3, 128);
    }

    public final int getId() {
        return this.iSensorId;
    }

    public synchronized void addSensorListener(SensorListener aListener) {
        if (this.iListeners == null) {
            this.iListeners = new SensorListener[8];
        }
        short s = this.iNumListeners;
        this.iNumListeners = (short)(s + 1);
        this.iListeners[s] = aListener;
        ListenerThread.get().addSensorToMask(this.iSensorId, this);
    }

    public final void activate() {
        ROM.call((short)6470, (short)(4096 + this.iSensorId));
    }

    public final void passivate() {
        ROM.call((short)6596, (short)(4096 + this.iSensorId));
    }

    public final void setTypeAndMode(int aType, int aMode) {
        Sensor.setSensorValue(this.iSensorId, aType, 1);
        Sensor.setSensorValue(this.iSensorId, aMode, 0);
    }

    public final void setPreviousValue(int aValue) {
        Sensor.setSensorValue(this.iSensorId, aValue, 2);
    }

    public static native int readSensorValue(int var0, int var1);

    private static native void setSensorValue(int var0, int var1, int var2);

    public synchronized void callListeners() {
        int newValue = Sensor.readSensorValue(this.iSensorId, 1);
        for (int i = 0; i < this.iNumListeners; ++i) {
            this.iListeners[i].stateChanged(this, this.iPreviousValue, newValue);
        }
        this.iPreviousValue = newValue;
    }
}

