/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.Sensor;
import josx.platform.rcx.SensorListener;
import josx.platform.rcx.Serial;

public class ProximitySensor
implements SensorListener {
    static final byte[] data = new byte[]{-1};
    Sensor sensor;
    int threshhold;

    public ProximitySensor(Sensor sensor) {
        this(sensor, 15);
    }

    public ProximitySensor(Sensor sensor, int threshhold) {
        this.sensor = sensor;
        sensor.setTypeAndMode(3, 128);
        sensor.activate();
        Serial.setRangeLong();
        this.threshhold = threshhold;
        sensor.addSensorListener(this);
        new Emitter().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillNear(long millis) throws InterruptedException {
        Sensor sensor = this.sensor;
        synchronized (sensor) {
            this.sensor.wait(millis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(Sensor sensor, int oldValue, int newValue) {
        if (newValue - oldValue > this.threshhold) {
            Sensor sensor2 = sensor;
            synchronized (sensor2) {
                sensor.notifyAll();
            }
        }
    }

    class Emitter
    extends Thread {
        public Emitter() {
            this.setDaemon(true);
            this.setPriority(10);
        }

        public void run() {
            while (true) {
                Serial.sendPacket(data, 0, 1);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

