/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.Memory;

public class PersistentMemoryArea {
    private static final int REGION_HEADER_SIZE = 2;
    private static final int ARRAY_HEADER_SIZE = 4;
    private static final int IS_ALLOCATED_MASK = 32768;
    private static final int IS_ARRAY_MASK = 16384;
    private static final int ELEM_TYPE_SHIFT = 9;
    private static final int T_INT = 10;
    private static final int INT_SIZE = 4;
    private static int regionAddress = PersistentMemoryArea.getRegionAddress();
    private static int blockHeaderAddress = regionAddress + 2;
    private static int magicAddress = blockHeaderAddress + 4;
    private static int sizeAddress = magicAddress + 2;
    private static int startAddress = sizeAddress + 2;
    private static PersistentMemoryArea singleton = null;
    private int size;

    private PersistentMemoryArea() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistentMemoryArea get(int magic, int size) throws OutOfMemoryError {
        if (singleton == null) {
            Object object = Memory.MONITOR;
            synchronized (object) {
                int arraySize = (size + 4 + 4 - 1) / 4;
                int blockSize = 2 + 4 * arraySize / 2;
                short blockHeader = Memory.readShort((short)blockHeaderAddress);
                if ((blockHeader & 0x8000) != 0 || blockSize > blockHeader || arraySize > 511) {
                    throw new OutOfMemoryError();
                }
                Memory.writeShort(blockHeaderAddress + 2 * blockSize, (short)(blockHeader - blockSize));
                blockHeader = (short)(0xD400 | arraySize);
                Memory.writeShort(blockHeaderAddress, blockHeader);
                if (Memory.readShort(magicAddress) != magic && Memory.readShort(sizeAddress) != size) {
                    for (int i = 0; i < size; i = (int)((short)(i + 1))) {
                        Memory.writeByte(startAddress + i, (byte)0);
                    }
                    Memory.writeShort(magicAddress, (short)magic);
                    Memory.writeShort(sizeAddress, (short)size);
                }
            }
            singleton = new PersistentMemoryArea();
            PersistentMemoryArea.singleton.size = size;
        }
        return singleton;
    }

    public byte readByte(int i) throws ArrayIndexOutOfBoundsException {
        if (i >= 0 && i < this.size) {
            return Memory.readByte(startAddress + i);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void writeByte(int i, byte b) throws ArrayIndexOutOfBoundsException {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Memory.writeByte(startAddress + i, b);
    }

    private static native int getRegionAddress();
}

