/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.ROM;

public class Motor {
    private char iId;
    private short iMode = (short)4;
    private short iPower = (short)3;
    public static final Motor A = new Motor('A');
    public static final Motor B = new Motor('B');
    public static final Motor C = new Motor('C');

    private Motor(char aId) {
        this.iId = aId;
    }

    public final char getId() {
        return this.iId;
    }

    public final void setPower(int aPower) {
        this.iPower = (short)aPower;
        Motor.controlMotor(this.iId, this.iMode, aPower);
    }

    public final void forward() {
        this.iMode = 1;
        Motor.controlMotor(this.iId, 1, this.iPower);
    }

    public final boolean isForward() {
        return this.iMode == 1;
    }

    public final void backward() {
        this.iMode = (short)2;
        Motor.controlMotor(this.iId, 2, this.iPower);
    }

    public final boolean isBackward() {
        return this.iMode == 2;
    }

    public final void reverseDirection() {
        if (this.iMode == 1 || this.iMode == 2) {
            this.iMode = (short)(3 - this.iMode);
            Motor.controlMotor(this.iId, this.iMode, this.iPower);
        }
    }

    public final int getPower() {
        return this.iPower;
    }

    public final boolean isMoving() {
        return this.iMode == 1 || this.iMode == 2;
    }

    public final boolean isFloating() {
        return this.iMode == 4;
    }

    public final void stop() {
        this.iMode = (short)3;
        Motor.controlMotor(this.iId, 3, 7);
    }

    public final boolean isStopped() {
        return this.iMode == 3;
    }

    public final void flt() {
        this.iMode = (short)4;
        Motor.controlMotor(this.iId, 4, this.iPower);
    }

    public static void controlMotor(char aMotor, int aMode, int aPower) {
        ROM.call((short)6734, (short)(8192 + aMotor - 65), (short)aMode, (short)aPower);
    }
}

