/*
 * Decompiled with CFR 0.152.
 */
package josx.platform.rcx;

import josx.platform.rcx.ButtonListener;
import josx.platform.rcx.ListenerCaller;
import josx.platform.rcx.ListenerThread;
import josx.platform.rcx.Memory;
import josx.platform.rcx.Poll;
import josx.platform.rcx.ROM;

public class Button
implements ListenerCaller {
    public static final Button RUN = new Button(1);
    public static final Button VIEW = new Button(2);
    public static final Button PRGM = new Button(4);
    public static final Button[] BUTTONS = new Button[]{RUN, VIEW, PRGM};
    private int iCode;
    private ButtonListener[] iListeners = new ButtonListener[4];
    private int iNumListeners;
    static Poll poller = new Poll();

    private Button(int aCode) {
        this.iCode = aCode;
    }

    public final int getId() {
        return this.iCode;
    }

    public final boolean isPressed() {
        return (Button.readButtons() & this.iCode) != 0;
    }

    public final void waitForPressAndRelease() throws InterruptedException {
        do {
            poller.poll(this.iCode << 3, 0);
        } while (this.isPressed());
    }

    public synchronized void addButtonListener(ButtonListener aListener) {
        if (this.iListeners == null) {
            this.iListeners = new ButtonListener[4];
        }
        this.iListeners[this.iNumListeners++] = aListener;
        ListenerThread.get().addButtonToMask(this.iCode, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readButtons() {
        Object object = Memory.MONITOR;
        synchronized (object) {
            int pAddr = Memory.iAuxDataAddr;
            ROM.call((short)8118, (short)12288, (short)pAddr);
            return Memory.readShort(pAddr);
        }
    }

    public synchronized void callListeners() {
        for (int i = 0; i < this.iNumListeners; ++i) {
            if (this.isPressed()) {
                this.iListeners[i].buttonPressed(this);
                continue;
            }
            this.iListeners[i].buttonReleased(this);
        }
    }
}

