/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tools.SendException;
import js.tools.SendTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Send
extends SendTool {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] args) throws IOException {
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        try {
            Send send = new Send(new CLIToolProgressMonitor());
            send.start(args);
        }
        catch (SendException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public Send(ToolProgressMonitor monitor) {
        super(monitor);
    }

    public void start(String[] args) throws SendException {
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        CommandLine commandLine = this.parse(args);
        boolean verbose = commandLine.hasOption("v");
        String tty = commandLine.getOptionValue("t");
        boolean fastMode = commandLine.hasOption("f");
        String[] bytes = commandLine.getArgs();
        ((CLIToolProgressMonitor)this.getProgressMonitor()).setVerbose(verbose);
        this.start(bytes, tty, fastMode);
    }

    public void start(String[] bytes, String tty, boolean fastMode) throws SendException {
        byte[] send = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            try {
                send[i] = (byte)Integer.parseInt(bytes[i], 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new SendException(e.getMessage(), e);
            }
        }
        this.start(send, tty, fastMode);
    }

    protected CommandLine parse(String[] args) throws SendException {
        CommandLine result;
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        Options options = new Options();
        options.addOption("v", "verbose", false, "be verbose");
        options.addOption("h", "help", false, "help");
        Option ttyOption = new Option("t", "tty", true, "tower port");
        ttyOption.setArgName("port");
        options.addOption(ttyOption);
        options.addOption("f", "fast", false, "fast mode");
        try {
            try {
                result = new GnuParser().parse(options, args);
            }
            catch (ParseException e) {
                throw new SendException(e.getMessage());
            }
            if (result.hasOption("h")) {
                throw new SendException("Help:");
            }
            if (!result.hasOption("t")) {
                throw new SendException("No tower port specified");
            }
            if (result.getArgs().length == 0) {
                throw new SendException("More bytes to send specified");
            }
        }
        catch (SendException e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println(e.getMessage());
            String usage = this.getClass().getName() + " [options] hexBytes";
            new HelpFormatter().printHelp(printWriter, 80, usage, null, options, 0, 2, null);
            throw new SendException(writer.toString());
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    static {
        $assertionsDisabled = !Send.class.desiredAssertionStatus();
    }
}

