/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import java.io.IOException;

public class SRec {
    private static final int SREC_DATA_SIZE = 256;
    private static final byte[] ctab = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] ltab = new int[]{4, 4, 6, 8, 0, 4, 0, 8, 6, 4};
    public byte type;
    public int addr;
    public byte count;
    public byte[] data;

    private static byte c1(char[] l, int p) {
        return ctab[l[p]];
    }

    private static byte c2(char[] l, int p) {
        return (byte)(SRec.c1(l, p) << 4 | SRec.c1(l, p + 1));
    }

    public SRec(char[] line, int len) throws IOException {
        int pos;
        if (line == null || len > line.length) {
            throw new IOException("Null String error");
        }
        if (len < 4 || line[0] != 'S') {
            throw new IOException("Invalid Header");
        }
        for (pos = 1; pos < len; ++pos) {
            if (SRec.c1(line, pos) >= 0) continue;
            throw new IOException("Invalid character");
        }
        this.type = SRec.c1(line, 1);
        int rest = SRec.c2(line, 2);
        if (this.type > 9) {
            throw new IOException("Invalid type");
        }
        int alen = ltab[this.type];
        if (alen == 0) {
            throw new IOException("Invalid type");
        }
        if (len < alen + 6) {
            throw new IOException("Line too short");
        }
        if (rest > alen + 256 + 2) {
            throw new IOException("Line too long");
        }
        if (len != rest * 2 + 4) {
            throw new IOException("Length error");
        }
        int sum = rest;
        this.addr = 0;
        for (pos = 4; pos < alen + 4; pos += 2) {
            int value = SRec.c2(line, pos);
            int val = value < 0 ? value + 256 : value;
            this.addr = this.addr << 8 | val;
            sum += val;
        }
        this.count = (byte)(rest - alen / 2 - 1);
        this.data = new byte[this.count];
        int i = 0;
        pos = alen + 4;
        while (pos < len - 2) {
            byte value;
            this.data[i] = value = SRec.c2(line, pos);
            sum += value;
            pos += 2;
            ++i;
        }
        if (((sum += SRec.c2(line, pos)) & 0xFF) != 255) {
            throw new IOException("Checksum error");
        }
    }
}

