/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import java.io.IOException;
import java.io.InputStream;
import js.common.AbstractTool;
import js.common.ToolException;
import js.common.ToolProgressMonitor;
import js.tools.Download;
import js.tools.LejosdlException;

public class LejosdlTool
extends AbstractTool {
    static final /* synthetic */ boolean $assertionsDisabled;

    public LejosdlTool(ToolProgressMonitor monitor) {
        super(monitor);
    }

    public void start(InputStream program, String tty, boolean fastMode) throws LejosdlException {
        this.start(program, tty, true, fastMode);
    }

    public void start(InputStream program, String tty, boolean download, boolean fastMode) throws LejosdlException {
        int index;
        if (!$assertionsDisabled && program == null) {
            throw new AssertionError((Object)"Precondition: program != null");
        }
        if (!$assertionsDisabled && tty == null) {
            throw new AssertionError((Object)"Precondition: tty != null");
        }
        byte[] buffer = new byte[65536];
        try {
            int read;
            this.getProgressMonitor().operation("read binary");
            for (index = 0; (read = program.read(buffer, index, 65536 - index)) != -1 && index < 65536; index += read) {
            }
            if (program.read() != -1) {
                while ((read = program.read(buffer, 0, 4096)) != -1) {
                    index += read;
                }
                throw new LejosdlException("Huge file: " + index + " bytes");
            }
            this.getProgressMonitor().progress(1000);
        }
        catch (IOException e) {
            throw new LejosdlException("Unable to read program: " + e.getMessage(), e);
        }
        finally {
            try {
                program.close();
            }
            catch (IOException e) {}
        }
        if (buffer[0] != -54 || buffer[1] != -10) {
            throw new LejosdlException("Magic number is not right.\nLinker used was for emulation only?");
        }
        if (download) {
            this.getProgressMonitor().operation("download binary");
            Download d = new Download(this.getProgressMonitor());
            try {
                d.open(tty, fastMode);
                d.downloadProgram(buffer, index);
                d.close();
            }
            catch (ToolException e) {
                throw new LejosdlException(e.getMessage(), e);
            }
            finally {
                if (d.isOpen()) {
                    d.close();
                }
            }
            this.getProgressMonitor().progress(1000);
        }
    }

    static {
        $assertionsDisabled = !LejosdlTool.class.desiredAssertionStatus();
    }
}

