/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import js.common.AbstractTool;
import js.common.NullToolProgressMonitor;
import js.common.ToolException;
import js.common.ToolProgressMonitor;
import js.tools.Download;
import js.tools.Firmdl;
import js.tools.FirmdlException;
import js.tools.SRec;

public class FirmdlTool
extends AbstractTool {
    private static final int SEGMENT_BREAK = 1024;
    private static final int IMAGE_START = 32768;
    private static final int IMAGE_MAXLEN = 32768;
    private static final int MAX_SEGMENTS = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FirmdlTool(ToolProgressMonitor monitor) {
        super(monitor);
    }

    public void start(String tty, boolean download, boolean fastMode) throws FirmdlException {
        Image image = this.getImage("lejos");
        this.start(image, tty, download, fastMode);
    }

    public void start(Reader reader, String tty, boolean download, boolean fastMode) throws FirmdlException {
        Image image = this.srecLoad(reader, 2, 32768);
        this.start(image, tty, download, fastMode);
    }

    public void start(Image image, String tty, boolean download, boolean fastMode) throws FirmdlException {
        this.log(image);
        if (download) {
            Download d;
            if (fastMode) {
                this.getProgressMonitor().operation("Installing fastmode firmware");
                d = new Download(new NullToolProgressMonitor());
                try {
                    String fastdl = tty.toLowerCase().indexOf("usb") == -1 ? "fastdl4x" : "fastdl2x";
                    Image fastImage = this.getImage(fastdl);
                    this.log(fastImage);
                    d.open(tty, false);
                    d.installFirmware(fastImage.data, fastImage.length(), 32768);
                    d.close();
                }
                catch (Exception e) {
                    throw new FirmdlException(e.getMessage(), e);
                }
                finally {
                    if (d.isOpen()) {
                        d.close();
                    }
                }
            }
            this.getProgressMonitor().operation("Installing firmware");
            d = new Download(this.getProgressMonitor());
            try {
                d.open(tty, fastMode);
                d.installFirmware(image.data, image.length(), image.entry);
                d.close();
            }
            catch (ToolException e) {
                throw new FirmdlException(e.getMessage(), e);
            }
            finally {
                if (d.isOpen()) {
                    d.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getImage(String name) throws FirmdlException {
        Image result;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError((Object)"Precondition: name != null");
        }
        InputStream stream = Firmdl.class.getResourceAsStream("/" + name + ".srec");
        if (stream == null) {
            throw new FirmdlException("Unable to find default firmware image " + name + ".srec");
        }
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            result = this.srecLoad(reader, 2, 32768);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new FirmdlException(e.getMessage(), e);
            }
            throw throwable;
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new FirmdlException(e.getMessage(), e);
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postcondition: result != null");
        }
        return result;
    }

    public void log(Image image) {
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError((Object)"Preconditon: image != null");
        }
        for (int i = 0; i < image.numSegments(); ++i) {
            this.getProgressMonitor().log("Segment " + i + ": length = " + image.segments[i].length);
        }
    }

    private Image srecLoad(Reader reader, int numimage_def, int maxlen) throws FirmdlException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        Image image = new Image();
        try {
            int i;
            String record;
            this.getProgressMonitor().operation("read firmware srec");
            SRec srec = null;
            int segStartAddr = 0;
            int prevAddr = -1024;
            int prevCount = 1024;
            boolean strip = false;
            int imageIndex = -1024;
            int length = 0;
            int segIndex = -1;
            int line = 0;
            while ((record = bufferedReader.readLine()) != null) {
                if ((record = record.trim()).length() == 0) continue;
                ++line;
                try {
                    char[] buf = record.toCharArray();
                    srec = new SRec(buf, buf.length);
                }
                catch (IOException e) {
                    throw new FirmdlException("Error on line " + line + " : " + e.getMessage(), e);
                }
                if (srec.type == 0) {
                    if (!new String(srec.data).equals("?LIB_VERSION_L00")) continue;
                    this.getProgressMonitor().log("Setting strip");
                    strip = true;
                    continue;
                }
                if (srec.type == 1) {
                    if (srec.addr - prevAddr >= 1024) {
                        image.segments[++segIndex] = new Segment();
                        if (segIndex >= numimage_def) {
                            throw new FirmdlException("Expected number of image_def exceeded");
                        }
                        image.segments[segIndex].length = 0;
                        segStartAddr = srec.addr;
                        prevAddr = srec.addr - prevCount;
                        image.segments[segIndex].offset = imageIndex + prevCount;
                    }
                    if (srec.addr < 32768 || srec.addr + srec.count > 32768 + maxlen) {
                        throw new FirmdlException("Address (" + srec.addr + ") out of bounds (srec) on line " + line + "\nCount = " + srec.count + "\nmaxlen = " + maxlen);
                    }
                    image.segments[segIndex].length = srec.addr - segStartAddr + srec.count;
                    imageIndex += srec.addr - prevAddr;
                    for (i = 0; i < srec.count; ++i) {
                        image.data[imageIndex + i] = srec.data[i];
                    }
                    prevAddr = srec.addr;
                    prevCount = srec.count;
                    continue;
                }
                if (srec.type != 9) continue;
                if (srec.addr < 32768 || srec.addr > 32768 + maxlen) {
                    throw new FirmdlException("Address out of bounds (image) on line" + line);
                }
                image.entry = srec.addr;
            }
            if (strip) {
                this.getProgressMonitor().log("Stripping");
                for (int pos = Short.MAX_VALUE; pos >= 0 && image.data[pos] == 0; --pos) {
                    --image.segments[segIndex].length;
                }
            }
            for (i = 0; i <= segIndex; ++i) {
                length += image.segments[segIndex].length;
            }
            if (length == 0) {
                throw new FirmdlException("Image contains no data");
            }
            this.getProgressMonitor().progress(1000);
        }
        catch (IOException e) {
            throw new FirmdlException("Unable to read srec: " + e.getMessage(), e);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {}
        }
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError((Object)"Postcondition: result != null");
        }
        return image;
    }

    static {
        $assertionsDisabled = !FirmdlTool.class.desiredAssertionStatus();
    }

    private static class Image {
        public int entry;
        public Segment[] segments = new Segment[2];
        public byte[] data = new byte[32768];

        private Image() {
        }

        public int numSegments() {
            int result = 0;
            for (int i = 0; i < this.segments.length && this.segments[i] != null; ++i) {
                ++result;
            }
            return result;
        }

        public int length() {
            int result = 0;
            for (int i = 0; i < this.numSegments(); ++i) {
                result += this.segments[i].length;
            }
            return result;
        }
    }

    private static class Segment {
        public int length;
        public int offset;

        private Segment() {
        }
    }
}

