/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tools.FirmdlException;
import js.tools.FirmdlTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Firmdl
extends FirmdlTool {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] args) {
        try {
            Firmdl firmdl = new Firmdl(new CLIToolProgressMonitor());
            firmdl.start(args);
        }
        catch (FirmdlException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public Firmdl(ToolProgressMonitor monitor) {
        super(monitor);
    }

    public void start(String[] args) throws FirmdlException {
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        CommandLine commandLine = this.parse(args);
        boolean verbose = commandLine.hasOption("v");
        String tty = commandLine.getOptionValue("t");
        boolean download = !commandLine.hasOption("n");
        boolean fastMode = commandLine.hasOption("f");
        String[] srecs = commandLine.getArgs();
        if (srecs.length == 0) {
            this.start(tty, download, fastMode);
        } else {
            try {
                this.start(new FileReader(srecs[0]), tty, download, fastMode);
            }
            catch (FileNotFoundException e) {
                throw new FirmdlException(e.getMessage(), e);
            }
        }
    }

    protected CommandLine parse(String[] args) throws FirmdlException {
        CommandLine result;
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        Options options = new Options();
        options.addOption("v", "verbose", false, "be verbose");
        options.addOption("h", "help", false, "help");
        Option ttyOption = new Option("t", "tty", true, "tower port");
        ttyOption.setArgName("port");
        options.addOption(ttyOption);
        options.addOption("f", "fast", false, "fast mode");
        options.addOption("n", "nodownload", false, "do not download");
        try {
            try {
                result = new GnuParser().parse(options, args);
            }
            catch (ParseException e) {
                throw new FirmdlException(e.getMessage());
            }
            if (result.hasOption("h")) {
                throw new FirmdlException("Help:");
            }
            if (!result.hasOption("t")) {
                throw new FirmdlException("No tower port specified");
            }
        }
        catch (FirmdlException e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println(e.getMessage());
            String usage = this.getClass().getName() + " [options] [firmware.srec]";
            new HelpFormatter().printHelp(printWriter, 80, usage, null, options, 0, 2, null);
            throw new FirmdlException(writer.toString());
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    static {
        $assertionsDisabled = !Firmdl.class.desiredAssertionStatus();
    }
}

