/*
 * Decompiled with CFR 0.152.
 */
package js.tools;

import josx.rcxcomm.Tower;
import josx.rcxcomm.TowerException;
import js.common.AbstractTool;
import js.common.ToolException;
import js.common.ToolProgressMonitor;

public class Download
extends AbstractTool {
    public static final int CHECKSUM_WAIT = 1000;
    private static final int WRITE_MAX = 200;
    private static final int MAX_ZEROS = 32;
    private static final int MAGIC = 51958;
    private Tower _tower;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Download(ToolProgressMonitor monitor) {
        super(monitor);
    }

    public void finalize() {
        if (this.isOpen()) {
            this.close();
        }
    }

    public boolean isOpen() {
        return this._tower != null;
    }

    public void open(String port, boolean fastMode) throws ToolException {
        if (!$assertionsDisabled && port == null) {
            throw new AssertionError((Object)"Precondition: port != null");
        }
        if (!$assertionsDisabled && this.isOpen()) {
            throw new AssertionError((Object)"Precondition: !isOpen()");
        }
        this._tower = new Tower(port);
        try {
            this._tower.openTower(fastMode);
        }
        catch (TowerException e) {
            throw new ToolException(e.getMessage(), e);
        }
        if (!this._tower.isRCXAlive()) {
            throw new ToolException("RCX not responding");
        }
        if (!$assertionsDisabled && !this.isOpen()) {
            throw new AssertionError((Object)"Postcondition: isOpen()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!$assertionsDisabled && !this.isOpen()) {
            throw new AssertionError((Object)"Precondition: isOpen()");
        }
        try {
            this._tower.closeTower();
        }
        catch (TowerException towerException) {
        }
        finally {
            this._tower = null;
        }
        if (!$assertionsDisabled && this.isOpen()) {
            throw new AssertionError((Object)"Postcondition: !isOpen()");
        }
    }

    public void downloadProgram(byte[] buffer, int length) throws ToolException {
        byte[] send = new byte[3];
        byte[] recv = new byte[3];
        this.getProgressMonitor().operation("download program");
        send[0] = 18;
        send[1] = -54;
        send[2] = -10;
        try {
            int numRead = this._tower.sendPacketReceivePacket(send, recv, 3);
            if (numRead < 3 || recv[1] != send[1] || recv[2] != send[2]) {
                throw new ToolException("RCX communication: unexpected response.\nThe RCX either doesn't have valid leJOS firmware or it is not in program-download mode.");
            }
        }
        catch (TowerException e) {
            throw new ToolException(e.getMessage() + "\nPlease make sure RCX has leJOS firmware and is in range." + "\nThe firmware must be in program download mode." + "\nTurn RCX off and on if necessary.");
        }
        this.transferData(buffer, length, true);
    }

    public void installFirmware(byte[] image, int length, int baseAddress) throws ToolException {
        this.deleteFirmware();
        this.downloadFirmware(image, length, baseAddress);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new ToolException("interrupted");
        }
        this.unlockFirmware();
    }

    public void downloadFirmware(byte[] image, int len, int baseAddress) throws ToolException {
        byte[] send = new byte[6];
        byte[] recv = new byte[2];
        this.getProgressMonitor().operation("Downloading firmware");
        int kB = (len + 1023) / 1024;
        this.getProgressMonitor().log("Total image size = " + len + " (" + kB + "kB)");
        int checksumlength = baseAddress + len < 52224 ? len : 52224 - baseAddress;
        short checksum = 0;
        for (int i = 0; i < checksumlength; ++i) {
            checksum = (short)(checksum + (image[i] < 0 ? image[i] + 256 : image[i]));
        }
        send[0] = 117;
        send[1] = (byte)(baseAddress >> 0 & 0xFF);
        send[2] = (byte)(baseAddress >> 8 & 0xFF);
        send[3] = (byte)(checksum >> 0 & 0xFF);
        send[4] = (byte)(checksum >> 8 & 0xFF);
        send[5] = 0;
        try {
            int numRead = this._tower.sendPacketReceivePacket(send, recv, 3);
            if (numRead == 0) {
                throw new ToolException("RCX communication: Start firmware download failed");
            }
        }
        catch (TowerException e) {
            throw new ToolException("Start firmware download failed: " + e.getMessage());
        }
        this.transferData(image, len, false);
        this.getProgressMonitor().operation("Firmware downloaded");
    }

    public void deleteFirmware() throws ToolException {
        byte[] send = new byte[6];
        byte[] recv = new byte[1];
        this.getProgressMonitor().operation("Deleting firmware");
        send[0] = 101;
        send[1] = 1;
        send[2] = 3;
        send[3] = 5;
        send[4] = 7;
        send[5] = 11;
        try {
            int numRead = this._tower.sendPacketReceivePacket(send, recv, 3);
            if (numRead != 1) {
                throw new ToolException("Delete firmware failed");
            }
        }
        catch (TowerException e) {
            throw new ToolException("Delete firmware failed: " + e.getMessage());
        }
        this.getProgressMonitor().operation("Firmware deleted");
    }

    public void unlockFirmware() throws ToolException {
        byte[] send = new byte[6];
        byte[] recv = new byte[27];
        this.getProgressMonitor().operation("Unlocking firmware");
        send[0] = -91;
        send[1] = 76;
        send[2] = 69;
        send[3] = 71;
        send[4] = 79;
        send[5] = -82;
        try {
            int numRead = this._tower.sendPacketReceivePacket(send, recv, 10);
            if (numRead == 0) {
                throw new ToolException("Unlock firmware failed");
            }
        }
        catch (TowerException e) {
            throw new ToolException("Unlock firmware failed: " + e.getMessage());
        }
        this.getProgressMonitor().operation("Firmware unlocked");
    }

    public void transferData(byte[] data, int length, boolean terminate0) throws ToolException {
        byte opcode = 69;
        int addr = 0;
        int block = 1;
        while (addr < length) {
            int numToWrite = this.maxLength(data, length, addr);
            if (this.getProgressMonitor().isCanceled()) {
                throw new ToolException("canceled");
            }
            this.getProgressMonitor().progress(addr * 1000 / length);
            block = terminate0 && length - addr <= 200 ? 0 : block;
            this.transferData(opcode, block, data, addr, numToWrite);
            opcode = (byte)(opcode ^ 8);
            addr += numToWrite;
            ++block;
        }
        this.getProgressMonitor().progress(1000);
    }

    public int maxLength(byte[] data, int length, int addr) {
        int result = Math.min(length - addr, 200);
        int count = 0;
        for (int i = 0; i < result; ++i) {
            if (data[addr + i] == 0) {
                if (++count < 32) continue;
                return i;
            }
            count = 0;
        }
        return result;
    }

    private void transferData(byte opcode, int index, byte[] data, int offset, int length) throws ToolException {
        block11: {
            byte[] send = new byte[length + 6];
            byte[] response = new byte[2];
            send[0] = opcode;
            send[1] = (byte)(index >> 0 & 0xFF);
            send[2] = (byte)(index >> 8 & 0xFF);
            send[3] = (byte)(length >> 0 & 0xFF);
            send[4] = (byte)(length >> 8 & 0xFF);
            byte checkSum = 0;
            for (int i = 0; i < length; ++i) {
                checkSum = (byte)(checkSum + data[offset + i]);
                send[5 + i] = data[offset + i];
            }
            send[5 + length] = checkSum;
            try {
                int numRead = this._tower.sendPacketReceivePacket(send, response, 10);
                if (numRead >= 2) {
                    if (response[0] != ~opcode) {
                        throw new ToolException("Error while downloading: wrong response");
                    }
                    switch (response[1]) {
                        case 0: {
                            break block11;
                        }
                        case 3: {
                            throw new ToolException("Error while downloading: checksum error");
                        }
                        case 4: {
                            throw new ToolException("Error while downloading: firmware checksum error");
                        }
                        case 6: {
                            throw new ToolException("Error while downloading: download not properly started");
                        }
                        default: {
                            throw new ToolException("Error while downloading: unknown error");
                        }
                    }
                }
                throw new ToolException("Error while downloading: response too short");
            }
            catch (TowerException e) {
                throw new ToolException("Error while downloading: " + e.getMessage());
            }
        }
    }

    static {
        $assertionsDisabled = !Download.class.desiredAssertionStatus();
    }
}

