/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import js.tinyvm.old.classfile.EClassFileFormat;

public class JIO {
    static void writeU2(OutputStream aOut, int aValue) throws Exception {
        if (aValue < 0 || aValue > 65535) {
            throw new EClassFileFormat("Value is not valid U2");
        }
        aOut.write(aValue >>> 8 & 0xFF);
        aOut.write(aValue & 0xFF);
    }

    static void writeU4(OutputStream aOut, int aValue) throws Exception {
        aOut.write(aValue >>> 24 & 0xFF);
        aOut.write(aValue >>> 16 & 0xFF);
        aOut.write(aValue >>> 8 & 0xFF);
        aOut.write(aValue & 0xFF);
    }

    static int readU2(InputStream aIn) throws Exception {
        int pByte2;
        int pByte1 = aIn.read();
        if ((pByte1 | (pByte2 = aIn.read())) < 0) {
            throw new EClassFileFormat("Unexpected EOF");
        }
        int pValue = pByte1 << 8 | pByte2;
        if (pValue < 0 || pValue > 65535) {
            throw new EClassFileFormat("Value is not valid U2");
        }
        return pValue;
    }

    static int readU4(InputStream aIn) throws Exception {
        int pByte4;
        int pByte3;
        int pByte2;
        int pByte1 = aIn.read();
        if ((pByte1 | (pByte2 = aIn.read()) | (pByte3 = aIn.read()) | (pByte4 = aIn.read())) < 0) {
            throw new EClassFileFormat("Unexpected EOF");
        }
        return pByte1 << 24 | pByte2 << 16 | pByte3 << 8 | pByte4;
    }
}

