/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import js.tinyvm.old.classfile.EClassFileFormat;
import js.tinyvm.old.classfile.IConstantPool;
import js.tinyvm.old.classfile.IConstantPoolEntry;
import js.tinyvm.old.classfile.IDumpable;
import js.tinyvm.old.classfile.JCPE_Class;
import js.tinyvm.old.classfile.JCPE_Double;
import js.tinyvm.old.classfile.JCPE_Dummy;
import js.tinyvm.old.classfile.JCPE_Fieldref;
import js.tinyvm.old.classfile.JCPE_Float;
import js.tinyvm.old.classfile.JCPE_Integer;
import js.tinyvm.old.classfile.JCPE_InterfaceMethodref;
import js.tinyvm.old.classfile.JCPE_Long;
import js.tinyvm.old.classfile.JCPE_Methodref;
import js.tinyvm.old.classfile.JCPE_NameAndType;
import js.tinyvm.old.classfile.JCPE_String;
import js.tinyvm.old.classfile.JCPE_Utf8;
import js.tinyvm.old.classfile.JConstantPoolEntry;
import js.tinyvm.old.classfile.JIO;

public class JConstantPool
implements IDumpable,
IConstantPool {
    private Vector iEntryTable = new Vector();
    private Hashtable iHashtable = new Hashtable();

    public boolean isValidIndex(int aIndex) {
        return aIndex >= 1 && aIndex <= this.iEntryTable.size();
    }

    public IConstantPoolEntry getEntry(int aIndex) throws Exception {
        if (aIndex == 0) {
            return null;
        }
        return (IConstantPoolEntry)this.iEntryTable.elementAt(aIndex - 1);
    }

    public Enumeration elements() {
        return this.iEntryTable.elements();
    }

    private void addEntryToTable(IConstantPoolEntry aObject) {
        this.iEntryTable.addElement(aObject);
        aObject.setEntryNumber(this.iEntryTable.size());
    }

    private void addEntry(IConstantPoolEntry aObject) {
        this.iEntryTable.addElement(aObject);
        this.iHashtable.put(aObject, aObject);
        aObject.setEntryNumber(this.iEntryTable.size());
    }

    public IConstantPoolEntry getEntry(IConstantPoolEntry aEntry) {
        IConstantPoolEntry pObj = (IConstantPoolEntry)this.iHashtable.get(aEntry);
        if (pObj != null) {
            return pObj;
        }
        this.addEntry(aEntry);
        if (aEntry instanceof JCPE_Double || aEntry instanceof JCPE_Long) {
            JCPE_Dummy pDummy = new JCPE_Dummy();
            this.addEntry(pDummy);
        }
        return aEntry;
    }

    private void updateEntries() throws Exception {
        Enumeration pEntries = this.iEntryTable.elements();
        while (pEntries.hasMoreElements()) {
            ((JConstantPoolEntry)pEntries.nextElement()).update();
        }
    }

    public final void dump(OutputStream aOut) throws Exception {
        int pSize = this.iEntryTable.size() + 1;
        JIO.writeU2(aOut, pSize);
        Enumeration pEntries = this.iEntryTable.elements();
        while (pEntries.hasMoreElements()) {
            ((JConstantPoolEntry)pEntries.nextElement()).dump(aOut);
        }
    }

    public final void read(InputStream aIn) throws Exception {
        this.iEntryTable.removeAllElements();
        this.iHashtable.clear();
        int pSize = JIO.readU2(aIn) - 1;
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            JConstantPoolEntry pEntry = this.readEntry(aIn);
            this.addEntryToTable(pEntry);
            if (!(pEntry instanceof JCPE_Double) && !(pEntry instanceof JCPE_Long)) continue;
            this.addEntryToTable(new JCPE_Dummy());
            ++pIndex;
        }
        this.updateEntries();
        this.hashEntryVector();
        if (pSize != this.iHashtable.size()) {
            throw new EClassFileFormat("Duplicate constant pool entries");
        }
    }

    private final void hashEntryVector() throws Exception {
        int pSize = this.iEntryTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            Object pObj = this.iEntryTable.elementAt(pIndex);
            if (this.iHashtable.contains(pObj)) {
                throw new EClassFileFormat("Duplicate Entry # " + pIndex + " : " + pObj);
            }
            this.iHashtable.put(pObj, pObj);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JConstantPoolEntry readEntry(InputStream aIn) throws Exception {
        void var2_3;
        int pTag = aIn.read();
        switch (pTag) {
            case 7: {
                JConstantPoolEntry pEntry = new JCPE_Class(this);
                pEntry.read(aIn);
                break;
            }
            case 9: {
                JConstantPoolEntry pEntry = new JCPE_Fieldref(this);
                pEntry.read(aIn);
                break;
            }
            case 10: {
                JConstantPoolEntry pEntry = new JCPE_Methodref(this);
                pEntry.read(aIn);
                break;
            }
            case 11: {
                JConstantPoolEntry pEntry = new JCPE_InterfaceMethodref(this);
                pEntry.read(aIn);
                break;
            }
            case 8: {
                JConstantPoolEntry pEntry = new JCPE_String(this);
                pEntry.read(aIn);
                break;
            }
            case 3: {
                JConstantPoolEntry pEntry = new JCPE_Integer(this);
                pEntry.read(aIn);
                break;
            }
            case 4: {
                JConstantPoolEntry pEntry = new JCPE_Float(this);
                pEntry.read(aIn);
                break;
            }
            case 5: {
                JConstantPoolEntry pEntry = new JCPE_Long(this);
                pEntry.read(aIn);
                break;
            }
            case 6: {
                JConstantPoolEntry pEntry = new JCPE_Double(this);
                pEntry.read(aIn);
                break;
            }
            case 12: {
                JConstantPoolEntry pEntry = new JCPE_NameAndType(this);
                pEntry.read(aIn);
                break;
            }
            case 1: {
                JConstantPoolEntry pEntry = new JCPE_Utf8();
                pEntry.read(aIn);
                break;
            }
            default: {
                throw new EClassFileFormat("Invalid Constant Pool Entry Tag: " + pTag);
            }
        }
        return var2_3;
    }

    public String toString() {
        int pIndex = 1;
        StringBuffer pStrBuf = new StringBuffer();
        pStrBuf.append("  CONSTANT POOL SIZE = " + this.iEntryTable.size() + "\n");
        Enumeration pEntries = this.iEntryTable.elements();
        while (pEntries.hasMoreElements()) {
            pStrBuf.append("  " + pIndex + " : ");
            pStrBuf.append(((JConstantPoolEntry)pEntries.nextElement()).toString() + "\n");
            ++pIndex;
        }
        return pStrBuf.toString();
    }
}

