/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import js.tinyvm.old.classfile.IConstants;
import js.tinyvm.old.classfile.IDumpable;
import js.tinyvm.old.classfile.JAttribute;
import js.tinyvm.old.classfile.JAttributeTable;
import js.tinyvm.old.classfile.JCPE_Utf8;
import js.tinyvm.old.classfile.JClassName;
import js.tinyvm.old.classfile.JCodeAttribute;
import js.tinyvm.old.classfile.JConstantPool;
import js.tinyvm.old.classfile.JExcepTable;
import js.tinyvm.old.classfile.JIO;
import js.tinyvm.old.classfile.JTable;

public abstract class JComponent
implements IDumpable,
IConstants {
    protected JTable iAttributes;
    private int iFlags;
    private JConstantPool iConstantPool;
    private JCPE_Utf8 iName;
    private JCPE_Utf8 iDescriptor;

    public JComponent(JConstantPool aConstantPool) {
        this.iConstantPool = aConstantPool;
        this.iFlags = 0;
        this.iAttributes = new JAttributeTable(this.iConstantPool);
    }

    public JComponent(JConstantPool aConstantPool, int aFlags, JCPE_Utf8 aName, JCPE_Utf8 aDescriptor) throws Exception {
        this.iConstantPool = aConstantPool;
        this.iFlags = aFlags;
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(aName);
        this.iDescriptor = (JCPE_Utf8)this.iConstantPool.getEntry(aDescriptor);
        this.iAttributes = new JAttributeTable(this.iConstantPool);
    }

    public JComponent(JConstantPool aConstantPool, int aFlags, String aName, String aDescriptor) throws Exception {
        this(aConstantPool, aFlags, new JCPE_Utf8(aName), new JCPE_Utf8(aDescriptor));
    }

    public JComponent(JConstantPool aConstantPool, int aFlags, String aName, Class[] aParamTypes, Class aRetType) throws Exception {
        this(aConstantPool, aFlags, aName, "");
        this.iDescriptor = (JCPE_Utf8)this.iConstantPool.getEntry(new JCPE_Utf8(JClassName.getMethodDescriptor(aParamTypes, aRetType)));
    }

    public JComponent(JConstantPool aConstantPool, int aFlags, String aName, Class aType) throws Exception {
        this(aConstantPool, aFlags, aName, "");
        this.iDescriptor = (JCPE_Utf8)this.iConstantPool.getEntry(new JCPE_Utf8(JClassName.getDescriptorForClass(aType)));
    }

    public JComponent(JConstantPool aConstantPool, Method aMethod) throws Exception {
        this(aConstantPool, aMethod.getModifiers(), aMethod.getName(), aMethod.getParameterTypes(), aMethod.getReturnType());
    }

    public JComponent(JConstantPool aConstantPool, Constructor aConstructor) throws Exception {
        this(aConstantPool, aConstructor.getModifiers(), "<init>", aConstructor.getParameterTypes(), Void.TYPE);
    }

    public JComponent(JConstantPool aConstantPool, Field aField) throws Exception {
        this(aConstantPool, aField.getModifiers(), aField.getName(), aField.getType());
    }

    public void addAttribute(JAttribute aAttribute) throws Exception {
        this.iAttributes.add(aAttribute);
    }

    public void setAccessFlags(int aFlags) {
        this.iFlags = aFlags;
    }

    public void setName(JCPE_Utf8 aName) {
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(aName);
    }

    public void setDescriptor(JCPE_Utf8 aDescriptor) {
        this.iDescriptor = (JCPE_Utf8)this.iConstantPool.getEntry(aDescriptor);
    }

    public void setCode(int aMaxStack, int aMaxLocals, byte[] aCode) throws Exception {
        this.addAttribute(new JCodeAttribute(this.iConstantPool, aMaxStack, aMaxLocals, aCode));
    }

    public void setCode(int aMaxStack, int aMaxLocals, byte[] aCode, JExcepTable aExcepTable, JAttributeTable aAttribTable) throws Exception {
        this.addAttribute(new JCodeAttribute(this.iConstantPool, aMaxStack, aMaxLocals, aCode, aExcepTable, aAttribTable));
    }

    public String toString() {
        return this.iName.toString() + " : " + this.iDescriptor.toString();
    }

    public final String getName() {
        return this.iName.toString();
    }

    public final JCPE_Utf8 getDescriptor() {
        return this.iDescriptor;
    }

    public boolean isNative() {
        return (this.iFlags & 0x100) != 0;
    }

    public boolean isAbstract() {
        return (this.iFlags & 0x400) != 0;
    }

    public boolean isStatic() {
        return (this.iFlags & 8) != 0;
    }

    public boolean isSynchronized() {
        return (this.iFlags & 0x20) != 0;
    }

    public void dump(OutputStream aOut) throws Exception {
        int pNameIndex = this.iName.getEntryNumber();
        int pDescriptorIndex = this.iDescriptor.getEntryNumber();
        JIO.writeU2(aOut, this.iFlags);
        JIO.writeU2(aOut, pNameIndex);
        JIO.writeU2(aOut, pDescriptorIndex);
        this.iAttributes.dump(aOut);
    }

    public void read(InputStream aIn) throws Exception {
        this.iFlags = JIO.readU2(aIn);
        int pNameIndex = JIO.readU2(aIn);
        int pDescriptorIndex = JIO.readU2(aIn);
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(pNameIndex);
        this.iDescriptor = (JCPE_Utf8)this.iConstantPool.getEntry(pDescriptorIndex);
        if (DEBUG_READ) {
            System.out.println("# Reading component: " + this.iName + "" + this.iDescriptor);
        }
        this.iAttributes.read(aIn);
    }
}

