/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import js.tinyvm.old.classfile.EClassFileFormat;
import js.tinyvm.old.classfile.IConstants;
import js.tinyvm.old.classfile.JAttribute;
import js.tinyvm.old.classfile.JAttributeTable;
import js.tinyvm.old.classfile.JCPE_Utf8;
import js.tinyvm.old.classfile.JConstantPool;
import js.tinyvm.old.classfile.JExcepTable;
import js.tinyvm.old.classfile.JIO;

public class JCodeAttribute
extends JAttribute
implements IConstants {
    private int iMaxStack;
    private int iMaxLocals;
    private JExcepTable iExcepTable;
    private JAttributeTable iAttribTable;
    public static final String kName = "Code";

    public JCodeAttribute(JConstantPool aConstantPool, int aMaxStack, int aMaxLocals, byte[] aCode, JExcepTable aExcepTable, JAttributeTable aAttribTable) {
        super(aConstantPool, kName, aCode);
        this.setName(kName);
        this.iMaxStack = aMaxStack;
        this.iMaxLocals = aMaxLocals;
        this.iExcepTable = aExcepTable;
        this.iAttribTable = aAttribTable;
    }

    public JCodeAttribute(JConstantPool aConstantPool, int aMaxStack, int aMaxLocals, byte[] aCode, JExcepTable aTable) {
        this(aConstantPool, aMaxStack, aMaxLocals, aCode, aTable, null);
        this.iAttribTable = new JAttributeTable(this.iConstantPool);
    }

    public JCodeAttribute(JConstantPool aConstantPool, int aMaxStack, int aMaxLocals, byte[] aCode) {
        this(aConstantPool, aMaxStack, aMaxLocals, aCode, null, null);
        this.iAttribTable = new JAttributeTable(this.iConstantPool);
        this.iExcepTable = new JExcepTable();
    }

    public JCodeAttribute(JConstantPool aConstantPool) {
        this(aConstantPool, -1, -1, null);
        this.iAttribTable = new JAttributeTable(this.iConstantPool);
        this.iExcepTable = new JExcepTable();
    }

    private int dumplength() throws Exception {
        return this.length() - 6;
    }

    public final int length() throws Exception {
        int pLength = 14 + this.getInfo().length + this.iExcepTable.length() + this.iAttribTable.length();
        return pLength;
    }

    public int getMaxLocals() {
        return this.iMaxLocals;
    }

    public int getMaxStack() {
        return this.iMaxStack;
    }

    public JExcepTable getExceptionTable() {
        return this.iExcepTable;
    }

    public boolean equals(Object aObj) {
        return System.identityHashCode(this) == System.identityHashCode(aObj);
    }

    public final void dump(OutputStream aOut) throws Exception {
        byte[] pCode = this.getInfo();
        int pCodeLength = pCode.length;
        JIO.writeU2(aOut, this.getName().getEntryNumber());
        JIO.writeU4(aOut, this.dumplength());
        JIO.writeU2(aOut, this.iMaxStack);
        JIO.writeU2(aOut, this.iMaxLocals);
        JIO.writeU4(aOut, pCodeLength);
        aOut.write(pCode, 0, pCodeLength);
        this.iExcepTable.dump(aOut);
        this.iAttribTable.dump(aOut);
    }

    public final void readInfo(InputStream aIn) throws Exception {
        int pDumpLength = JIO.readU4(aIn);
        this.iMaxStack = JIO.readU2(aIn);
        this.iMaxLocals = JIO.readU2(aIn);
        int pCodeLength = JIO.readU4(aIn);
        if (DEBUG_READ) {
            System.out.println("# Max stack: " + this.iMaxStack);
            System.out.println("# Max locals: " + this.iMaxLocals);
            System.out.println("# Code length: " + pCodeLength);
        }
        byte[] pCode = new byte[pCodeLength];
        int pTotalRead = 0;
        while ((pTotalRead += aIn.read(pCode, pTotalRead, pCodeLength - pTotalRead)) < pCodeLength) {
        }
        if (DEBUG_READ && pCodeLength >= 2) {
            System.out.println("# Bytecodes: ");
            for (int i = 0; i < pCodeLength; ++i) {
                System.out.println("   " + i + ": " + (pCode[i] & 0xFF));
            }
        }
        this.setInfo(pCode);
        this.iExcepTable = new JExcepTable();
        this.iExcepTable.read(aIn);
        this.iAttribTable = new JAttributeTable(this.iConstantPool);
        this.iAttribTable.read(aIn);
        if (this.dumplength() != pDumpLength) {
            throw new EClassFileFormat("Attribute length mistatch: " + this.dumplength() + "/" + pDumpLength);
        }
    }

    public final void read(InputStream aIn) throws Exception {
        int pIndex = JIO.readU2(aIn);
        this.setName((JCPE_Utf8)this.iConstantPool.getEntry(pIndex));
        this.readInfo(aIn);
    }
}

