/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.util.Vector;
import js.tinyvm.old.classfile.IConstants;
import js.tinyvm.old.classfile.JCPE_Utf8;

public class JClassName
implements IConstants {
    public static String getQualifiedName(String aClassName) {
        return aClassName.replace('.', '/');
    }

    public static String getMethodDescriptor(String[] aParamDescriptors, String aRetTypeDescriptor) {
        StringBuffer pStr = new StringBuffer();
        pStr.append("(");
        for (int pIndex = 0; pIndex < aParamDescriptors.length; ++pIndex) {
            pStr.append(aParamDescriptors[pIndex]);
        }
        pStr.append(")");
        pStr.append(aRetTypeDescriptor);
        return pStr.toString();
    }

    public static String getMethodDescriptor(Class[] aParamTypes, Class aRetType) throws Exception {
        String pDesc = JClassName.getMethodDescriptor(JClassName.getDescriptorForClasses(aParamTypes), JClassName.getDescriptorForClass(aRetType));
        return pDesc;
    }

    public static String getDescriptorForClass(String aClassName) {
        return "L" + aClassName.replace('.', '/') + ";";
    }

    public static String[] getDescriptorForClasses(Class[] aClasses) throws Exception {
        String[] pParTypes = new String[aClasses.length];
        for (int pIndex = 0; pIndex < aClasses.length; ++pIndex) {
            pParTypes[pIndex] = JClassName.getDescriptorForClass(aClasses[pIndex]);
        }
        return pParTypes;
    }

    public static String getDescriptorForClass(Class aClass) throws Exception {
        if (aClass.isPrimitive()) {
            if (aClass == Byte.TYPE) {
                return JClassName.getDescriptorForByte();
            }
            if (aClass == Character.TYPE) {
                return JClassName.getDescriptorForChar();
            }
            if (aClass == Double.TYPE) {
                return JClassName.getDescriptorForDouble();
            }
            if (aClass == Float.TYPE) {
                return JClassName.getDescriptorForFloat();
            }
            if (aClass == Integer.TYPE) {
                return JClassName.getDescriptorForInt();
            }
            if (aClass == Long.TYPE) {
                return JClassName.getDescriptorForLong();
            }
            if (aClass == Short.TYPE) {
                return JClassName.getDescriptorForShort();
            }
            if (aClass == Boolean.TYPE) {
                return JClassName.getDescriptorForBoolean();
            }
            if (aClass == Void.TYPE) {
                return JClassName.getDescriptorForVoid();
            }
            throw new RuntimeException("Unknown primitive class type: " + aClass.getName());
        }
        if (aClass.isArray()) {
            return JClassName.getDescriptorForArray(JClassName.getDescriptorForClass(aClass.getComponentType()));
        }
        return JClassName.getDescriptorForClass(aClass.getName());
    }

    public static String getDescriptorForArray(String aDescriptor) {
        return "[" + aDescriptor;
    }

    public static String getDescriptorForVoid() {
        return "V";
    }

    public static String getDescriptorForByte() {
        return "B";
    }

    public static String getDescriptorForChar() {
        return "C";
    }

    public static String getDescriptorForDouble() {
        return "D";
    }

    public static String getDescriptorForFloat() {
        return "F";
    }

    public static String getDescriptorForInt() {
        return "I";
    }

    public static String getDescriptorForLong() {
        return "J";
    }

    public static String getDescriptorForShort() {
        return "S";
    }

    public static String getDescriptorForBoolean() {
        return "Z";
    }

    public static String[] parseMethodParameters(JCPE_Utf8 aMethodDesc) {
        String pDesc = aMethodDesc.toString();
        int pIdx = pDesc.indexOf(41);
        if (pIdx == -1 || pDesc.charAt(0) != '(') {
            throw new Error(pDesc);
        }
        return JClassName.parseParameters(pDesc.substring(1, pIdx));
    }

    private static String[] parseParameters(String aParams) {
        String pDesc = aParams;
        int pLen = pDesc.length();
        Vector<String> pVec = new Vector<String>();
        String pPrefix = "";
        block5: for (int i = 0; i < pLen; ++i) {
            char pChar = pDesc.charAt(i);
            switch (pChar) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    pVec.addElement(pPrefix + pChar);
                    pPrefix = "";
                    continue block5;
                }
                case 'L': {
                    int pIdx = pDesc.indexOf(59, i + 1);
                    if (pIdx == -1) {
                        throw new Error(pDesc);
                    }
                    pVec.addElement(pPrefix + pDesc.substring(i, pIdx + 1));
                    pPrefix = "";
                    i = pIdx;
                }
                case '[': {
                    pPrefix = pPrefix + pChar;
                    continue block5;
                }
                default: {
                    throw new Error(pDesc + ": " + pChar);
                }
            }
        }
        Object[] pArgs = new String[pVec.size()];
        pVec.copyInto(pArgs);
        return pArgs;
    }

    public static int[] getTypeAndDimensions(String aMultiArrayDesc) {
        int i = 0;
        while (aMultiArrayDesc.charAt(i) == '[') {
            ++i;
        }
        return new int[]{JClassName.descriptorToType(aMultiArrayDesc.substring(i)), i};
    }

    public static int descriptorToType(String aDesc) {
        switch (aDesc.charAt(0)) {
            case 'B': {
                return 8;
            }
            case 'C': {
                return 5;
            }
            case 'D': {
                return 7;
            }
            case 'F': {
                return 6;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
            case 'S': {
                return 9;
            }
            case 'Z': {
                return 4;
            }
            case 'L': 
            case '[': {
                return 0;
            }
        }
        throw new Error("Bug IFR-2: " + aDesc);
    }

    public static int getTypeSize(int aType) {
        switch (aType) {
            case 4: 
            case 8: {
                return 1;
            }
            case 5: 
            case 9: {
                return 2;
            }
            case 0: 
            case 6: 
            case 10: {
                return 4;
            }
            case 7: 
            case 11: {
                return 8;
            }
        }
        throw new Error("Bug IFR-3: " + aType);
    }
}

