/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import js.tinyvm.old.classfile.EClassFileFormat;
import js.tinyvm.old.classfile.IConstantPool;
import js.tinyvm.old.classfile.IConstants;
import js.tinyvm.old.classfile.IDumpable;
import js.tinyvm.old.classfile.JAttributeTable;
import js.tinyvm.old.classfile.JCPE_Class;
import js.tinyvm.old.classfile.JCPE_Methodref;
import js.tinyvm.old.classfile.JCP_Index;
import js.tinyvm.old.classfile.JConstantPool;
import js.tinyvm.old.classfile.JConstructor;
import js.tinyvm.old.classfile.JField;
import js.tinyvm.old.classfile.JFieldTable;
import js.tinyvm.old.classfile.JIO;
import js.tinyvm.old.classfile.JIndexTable;
import js.tinyvm.old.classfile.JMethod;
import js.tinyvm.old.classfile.JMethodTable;
import js.tinyvm.old.classfile.JStatic;
import js.tinyvm.old.classfile.JTable;

public class JClassFile
implements IDumpable,
IConstants {
    private int iFlags = 0;
    private JTable iFields;
    private JTable iMethods;
    private JTable iInterfaces;
    private JTable iAttributes;
    private JConstantPool iConstantPool = new JConstantPool();
    private JCP_Index iThisClass = null;
    private JCP_Index iSuperClass = null;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int kMinorVersion = 3;
    public static final int kMajorVersion = 45;

    public JClassFile() {
        this.iFields = new JFieldTable(this.iConstantPool);
        this.iMethods = new JMethodTable(this.iConstantPool);
        this.iInterfaces = new JIndexTable(this.iConstantPool);
        this.iAttributes = new JAttributeTable(this.iConstantPool);
    }

    public JCPE_Class getSuperClass() {
        return (JCPE_Class)this.iSuperClass.getEntry();
    }

    public JCPE_Class getThisClass() {
        return (JCPE_Class)this.iThisClass.getEntry();
    }

    public String getName() {
        return this.getThisClass().getName().toString();
    }

    public void addMethod(JMethod aMethod) throws Exception {
        this.iMethods.add(aMethod);
    }

    public void addConstructor(JConstructor aMethod) throws Exception {
        this.iMethods.add(aMethod);
    }

    public void addStatic(JStatic aMethod) throws Exception {
        this.iMethods.add(aMethod);
    }

    public void addField(JField aField) throws Exception {
        this.iFields.add(aField);
    }

    public JMethod getMethod(Method aMethod) throws Exception {
        return new JMethod(this.iConstantPool, aMethod);
    }

    public JTable getMethods() {
        return this.iMethods;
    }

    public JTable getFields() {
        return this.iFields;
    }

    public JConstructor getConstructor(Constructor aConstructor) throws Exception {
        return new JConstructor(this.iConstantPool, aConstructor);
    }

    public void setSuperClass(JCP_Index aIndex) {
        this.iSuperClass = aIndex;
    }

    public void setSuperClass(String aName) throws Exception {
        JCPE_Class pClass = new JCPE_Class((IConstantPool)this.iConstantPool, aName);
        this.iSuperClass = new JCP_Index(this.iConstantPool, pClass);
    }

    public void setSuperClass(Class aClass) throws Exception {
        this.setSuperClass(aClass.getName());
    }

    public void setThisClass(JCP_Index aIndex) {
        this.iThisClass = aIndex;
    }

    public void setThisClass(String aName) throws Exception {
        JCPE_Class pClass = new JCPE_Class((IConstantPool)this.iConstantPool, aName);
        this.iThisClass = new JCP_Index(this.iConstantPool, pClass);
    }

    public void addInterface(JCP_Index aEntry) throws Exception {
        this.iInterfaces.add(aEntry);
    }

    public void addInterface(String aName) throws Exception {
        JCPE_Class pClass = new JCPE_Class((IConstantPool)this.iConstantPool, aName);
        this.iInterfaces.add(new JCP_Index(this.iConstantPool, pClass));
    }

    public JConstantPool getConstantPool() {
        return this.iConstantPool;
    }

    public void setFlags(int aFlags) {
        this.iFlags = aFlags;
    }

    public void addFlags(int aFlags) {
        this.iFlags |= aFlags;
    }

    public JCPE_Methodref getConstructorref(Class aClass, Constructor aCons) throws Exception {
        return (JCPE_Methodref)this.iConstantPool.getEntry(new JCPE_Methodref((IConstantPool)this.iConstantPool, aClass, aCons));
    }

    public JCPE_Methodref getMethodref(Class aClass, Method aMeth) throws Exception {
        return (JCPE_Methodref)this.iConstantPool.getEntry(new JCPE_Methodref((IConstantPool)this.iConstantPool, aClass, aMeth));
    }

    private void dumpMagicAndVersions(OutputStream aOut) throws Exception {
        JIO.writeU4(aOut, -889275714);
        JIO.writeU2(aOut, 3);
        JIO.writeU2(aOut, 45);
    }

    public final void dump(OutputStream aOut) throws Exception {
        this.dumpMagicAndVersions(aOut);
        this.iConstantPool.dump(aOut);
        JIO.writeU2(aOut, this.iFlags);
        if (this.iThisClass == null) {
            throw new EClassFileFormat("ThisClass has not been set");
        }
        this.iThisClass.dump(aOut);
        if (this.iSuperClass == null) {
            throw new EClassFileFormat("SuperClass has not been set");
        }
        this.iSuperClass.dump(aOut);
        this.iInterfaces.dump(aOut);
        this.iFields.dump(aOut);
        this.iMethods.dump(aOut);
        this.iAttributes.dump(aOut);
    }

    private void readMagicAndVersions(InputStream aIn) throws Exception {
        int pMagic = JIO.readU4(aIn);
        if (pMagic != -889275714) {
            throw new EClassFileFormat("Magic Number is " + pMagic);
        }
        int pMinorVersion = JIO.readU2(aIn);
        int pMajorVersion = JIO.readU2(aIn);
        if (pMinorVersion != 3 || pMajorVersion != 45) {
            throw new EClassFileFormat("Version not recognized: " + pMajorVersion + "." + pMinorVersion);
        }
    }

    private void readAccessFlags(InputStream aIn) throws Exception {
        this.iFlags = JIO.readU2(aIn);
    }

    private void readThisClass(InputStream aIn) throws Exception {
        if (this.iThisClass == null) {
            this.iThisClass = new JCP_Index(this.iConstantPool);
        }
        this.iThisClass.read(aIn);
    }

    private void readSuperClass(InputStream aIn) throws Exception {
        if (this.iSuperClass == null) {
            this.iSuperClass = new JCP_Index(this.iConstantPool);
        }
        this.iSuperClass.read(aIn);
    }

    public final void read(InputStream aIn) throws Exception {
        this.readMagicAndVersions(aIn);
        this.iConstantPool.read(aIn);
        if (DEBUG_READ) {
            System.out.println("# Reading access flags");
        }
        this.readAccessFlags(aIn);
        if (DEBUG_READ) {
            System.out.println("# Access flags = " + this.iFlags);
        }
        this.readThisClass(aIn);
        if (DEBUG_READ) {
            System.out.println("# Reading superclass");
        }
        this.readSuperClass(aIn);
        if (DEBUG_READ) {
            System.out.println("# Reading interfaces");
        }
        this.iInterfaces.read(aIn);
        if (DEBUG_READ) {
            System.out.println("# Reading fields");
        }
        this.iFields.read(aIn);
        if (DEBUG_READ) {
            System.out.println("# Reading methods");
        }
        this.iMethods.read(aIn);
        if (DEBUG_READ) {
            System.out.println("# Reading attributes");
        }
        this.iAttributes.read(aIn);
    }

    public boolean isInterface() {
        return (this.iFlags & 0x200) != 0;
    }

    public String toString() {
        return "Major Version: 45\nMinor Version: 3\nFlags: " + this.iFlags + "\n" + "This Class: " + this.iThisClass.toString() + "\n" + "Superclass: " + this.iSuperClass.toString() + "\n" + "Interfaces: " + this.iInterfaces.toString() + "\n" + "Fields:\n" + this.iFields.toString() + "\n" + "Methods:\n" + this.iMethods.toString() + "\n" + "Attrubutes:\n" + this.iAttributes.toString() + "\n" + "Constant pool:\n" + this.iConstantPool.toString();
    }
}

