/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import js.tinyvm.old.classfile.JConstantPoolEntry;
import js.tinyvm.old.classfile.JIO;
import js.tinyvm.old.classfile.JMisc;
import js.tinyvm.old.classfile.JUtf8;

public class JCPE_Utf8
extends JConstantPoolEntry {
    private byte[] iBytes;
    private int iLength;

    public JCPE_Utf8(String aString) {
        super(null);
        this.iBytes = new byte[JUtf8.getMaxLength(aString)];
        this.iLength = JUtf8.stringToUtf8(aString, this.iBytes, 0);
    }

    public JCPE_Utf8() {
        super(null);
    }

    public byte[] getBytes() {
        byte[] pBytes = new byte[this.iLength];
        System.arraycopy(this.iBytes, 0, pBytes, 0, this.iLength);
        return pBytes;
    }

    public void dump(OutputStream aOut) throws Exception {
        aOut.write(1);
        JIO.writeU2(aOut, this.iLength);
        aOut.write(this.iBytes, 0, this.iLength);
    }

    public void read(InputStream aIn) throws Exception {
        this.iLength = JIO.readU2(aIn);
        if (this.iBytes == null || this.iBytes.length < this.iLength) {
            this.iBytes = new byte[this.iLength];
        }
        int pRead = 0;
        while ((pRead += aIn.read(this.iBytes, pRead, this.iLength - pRead)) < this.iLength) {
        }
    }

    public final void update() {
    }

    public int getSize() {
        return this.iLength;
    }

    public int hashCode() {
        return JMisc.hashSignature(this.iBytes, 0, this.iLength);
    }

    public boolean equals(Object aObj) {
        if (aObj instanceof JCPE_Utf8) {
            JCPE_Utf8 pUtf = (JCPE_Utf8)aObj;
            return JMisc.equalArrays(this.iBytes, 0, this.iLength, pUtf.iBytes, 0, pUtf.iLength);
        }
        return false;
    }

    public String toString() {
        return JUtf8.Utf8ToString(this.iBytes, 0, this.iLength);
    }
}

