/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import js.tinyvm.old.classfile.EConstantPool;
import js.tinyvm.old.classfile.IConstantPool;
import js.tinyvm.old.classfile.JCPE_Class;
import js.tinyvm.old.classfile.JCPE_NameAndType;
import js.tinyvm.old.classfile.JConstantPoolEntry;
import js.tinyvm.old.classfile.JIO;

public abstract class JCPE_RefEntry
extends JConstantPoolEntry {
    private int iTag;
    private int iClassIndex;
    private int iNameAndTypeIndex;
    private JCPE_Class iClass;
    private JCPE_NameAndType iNameAndType;

    public JCPE_RefEntry(IConstantPool aConstantPool, int aTag, JCPE_Class aClass, JCPE_NameAndType aNameAndType) throws Exception {
        super(aConstantPool);
        this.iTag = aTag;
        this.iClass = (JCPE_Class)this.iConstantPool.getEntry(aClass);
        this.iNameAndType = (JCPE_NameAndType)this.iConstantPool.getEntry(aNameAndType);
    }

    public JCPE_RefEntry(IConstantPool aConstantPool, int aTag) {
        super(aConstantPool);
        this.iTag = aTag;
    }

    public JCPE_Class getClassEntry() {
        return this.iClass;
    }

    void setClass(JCPE_Class aClass) {
        this.iClass = aClass;
    }

    void setNameAndType(JCPE_NameAndType aNameAndType) {
        this.iNameAndType = aNameAndType;
    }

    public JCPE_NameAndType getNameAndType() {
        return this.iNameAndType;
    }

    public void dump(OutputStream aOut) throws Exception {
        aOut.write(this.iTag);
        JIO.writeU2(aOut, this.iClass.getEntryNumber());
        JIO.writeU2(aOut, this.iNameAndType.getEntryNumber());
    }

    public void read(InputStream aIn) throws Exception {
        this.iClassIndex = JIO.readU2(aIn);
        this.iNameAndTypeIndex = JIO.readU2(aIn);
    }

    public final void update() throws Exception {
        if (this.iClassIndex == -1) {
            throw new EConstantPool("update: class index not valid");
        }
        this.iClass = (JCPE_Class)this.iConstantPool.getEntry(this.iClassIndex);
        if (this.iNameAndTypeIndex == -1) {
            throw new EConstantPool("update: NameAndType index not valid");
        }
        this.iNameAndType = (JCPE_NameAndType)this.iConstantPool.getEntry(this.iNameAndTypeIndex);
    }

    public int hashCode() {
        return this.iClass.hashCode() + this.iNameAndType.hashCode();
    }

    public boolean equals(Object aObj) {
        if (aObj instanceof JCPE_RefEntry) {
            JCPE_RefEntry pEntry = (JCPE_RefEntry)aObj;
            return this.iClass.equals(pEntry.iClass) && this.iNameAndType.equals(pEntry.iNameAndType);
        }
        return false;
    }

    public String toString() {
        return this.iClass.toString() + " : " + this.iNameAndType.toString();
    }
}

