/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import js.tinyvm.old.classfile.EConstantPool;
import js.tinyvm.old.classfile.IConstantPool;
import js.tinyvm.old.classfile.JCPE_Utf8;
import js.tinyvm.old.classfile.JClassName;
import js.tinyvm.old.classfile.JConstantPoolEntry;
import js.tinyvm.old.classfile.JIO;

public class JCPE_NameAndType
extends JConstantPoolEntry {
    JCPE_Utf8 iName;
    JCPE_Utf8 iDescriptor;
    int iNameIndex;
    int iDescriptorIndex;

    public JCPE_NameAndType(IConstantPool aConstantPool, JCPE_Utf8 aName, JCPE_Utf8 aDescriptor) throws Exception {
        super(aConstantPool);
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(aName);
        this.iDescriptor = (JCPE_Utf8)this.iConstantPool.getEntry(aDescriptor);
    }

    public JCPE_NameAndType(IConstantPool aConstantPool, String aName, String aDescriptor) throws Exception {
        this(aConstantPool, new JCPE_Utf8(aName), new JCPE_Utf8(aDescriptor));
    }

    public JCPE_NameAndType(IConstantPool aConstantPool, Method aMethod) throws Exception {
        this(aConstantPool, aMethod.getName(), JClassName.getMethodDescriptor(aMethod.getParameterTypes(), aMethod.getReturnType()));
    }

    public JCPE_NameAndType(IConstantPool aConstantPool, Constructor aConstructor) throws Exception {
        this(aConstantPool, "<init>", JClassName.getMethodDescriptor(aConstructor.getParameterTypes(), Void.TYPE));
    }

    public JCPE_NameAndType(IConstantPool aConstantPool, Field aField) throws Exception {
        this(aConstantPool, aField.getName(), JClassName.getDescriptorForClass(aField.getType()));
    }

    public JCPE_NameAndType(IConstantPool aConstantPool) {
        super(aConstantPool);
    }

    public String getName() {
        return this.iName.toString();
    }

    public String getDescriptor() {
        return this.iDescriptor.toString();
    }

    public void dump(OutputStream aOut) throws Exception {
        aOut.write(12);
        JIO.writeU2(aOut, this.iName.getEntryNumber());
        JIO.writeU2(aOut, this.iDescriptor.getEntryNumber());
    }

    public void read(InputStream aIn) throws Exception {
        this.iNameIndex = JIO.readU2(aIn);
        this.iDescriptorIndex = JIO.readU2(aIn);
        this.iName = null;
        this.iDescriptor = null;
    }

    public final void update() throws Exception {
        if (this.iNameIndex == -1) {
            throw new EConstantPool("update: NameIndex not valid");
        }
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(this.iNameIndex);
        if (this.iDescriptorIndex == -1) {
            throw new EConstantPool("update: DescriptorIndex not valid");
        }
        this.iDescriptor = (JCPE_Utf8)this.iConstantPool.getEntry(this.iDescriptorIndex);
    }

    public int hashCode() {
        return this.iName.hashCode() + this.iDescriptor.hashCode();
    }

    public boolean equals(Object aObj) {
        if (aObj instanceof JCPE_NameAndType) {
            return this.iName.equals(((JCPE_NameAndType)aObj).iName) && this.iDescriptor.equals(((JCPE_NameAndType)aObj).iName);
        }
        return false;
    }

    public String toString() {
        return this.iName.toString() + " : " + this.iDescriptor.toString();
    }
}

