/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old.classfile;

import java.io.InputStream;
import java.io.OutputStream;
import js.tinyvm.old.classfile.IDumpable;
import js.tinyvm.old.classfile.JCPE_Utf8;
import js.tinyvm.old.classfile.JConstantPool;
import js.tinyvm.old.classfile.JIO;

public class JAttribute
implements IDumpable {
    private byte[] iInfo;
    private JCPE_Utf8 iName;
    protected JConstantPool iConstantPool;

    JAttribute(JConstantPool aConstantPool) {
        this.iConstantPool = aConstantPool;
    }

    public JAttribute(JConstantPool aConstantPool, JCPE_Utf8 aName, byte[] aInfo) {
        this.iConstantPool = aConstantPool;
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(aName);
        this.iInfo = aInfo;
    }

    public JAttribute(JConstantPool aConstantPool, String aName, byte[] aInfo) {
        this(aConstantPool, new JCPE_Utf8(aName), aInfo);
    }

    public JAttribute(JConstantPool aConstantPool, String aName) {
        this(aConstantPool, aName, null);
    }

    public String toString() {
        return this.iName.toString();
    }

    public void setInfo(byte[] aInfo) {
        this.iInfo = aInfo;
    }

    public byte[] getInfo() {
        return this.iInfo;
    }

    public void setName(JCPE_Utf8 aName) {
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(aName);
    }

    public void setName(String aName) {
        this.setName(new JCPE_Utf8(aName));
    }

    public JCPE_Utf8 getName() {
        return this.iName;
    }

    public int length() throws Exception {
        if (this.iInfo == null) {
            return 6;
        }
        return 6 + this.iInfo.length;
    }

    public boolean equals(Object aObj) {
        if (aObj instanceof JAttribute) {
            return this.iName.equals(((JAttribute)aObj).iName) && this.iInfo.equals(((JAttribute)aObj).iInfo);
        }
        return false;
    }

    public void dump(OutputStream aOut) throws Exception {
        int pNameIndex = this.iName.getEntryNumber();
        JIO.writeU2(aOut, pNameIndex);
        JIO.writeU4(aOut, this.iInfo.length);
        aOut.write(this.iInfo, 0, this.iInfo.length);
    }

    public String readName(InputStream aIn) throws Exception {
        int pNameIndex = JIO.readU2(aIn);
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(pNameIndex);
        return this.iName.toString();
    }

    public void readInfo(InputStream aIn) throws Exception {
        int pLength = JIO.readU4(aIn);
        this.iInfo = new byte[pLength];
        int pRead = 0;
        while ((pRead += aIn.read(this.iInfo, pRead, pLength - pRead)) < pLength) {
        }
    }

    public void read(InputStream aIn) throws Exception {
        int pNameIndex = JIO.readU2(aIn);
        this.iName = (JCPE_Utf8)this.iConstantPool.getEntry(pNameIndex);
        this.readInfo(aIn);
    }
}

