/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.TinyVMTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class TinyVM
extends TinyVMTool {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] args) {
        try {
            TinyVM tinyVM = new TinyVM(new CLIToolProgressMonitor());
            tinyVM.start(args);
        }
        catch (TinyVMException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public TinyVM(ToolProgressMonitor monitor) {
        super(monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(String[] args) throws TinyVMException {
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        CommandLine commandLine = this.parse(args);
        boolean verbose = commandLine.hasOption("v");
        String classpath = commandLine.getOptionValue("cp");
        String output = commandLine.getOptionValue("o");
        boolean all = commandLine.hasOption("a");
        boolean bigEndian = "be".equalsIgnoreCase(commandLine.getOptionValue("wo"));
        String[] classes = commandLine.getArgs();
        ((CLIToolProgressMonitor)this.getProgressMonitor()).setVerbose(verbose);
        OutputStream stream = null;
        try {
            try {
                stream = output == null ? System.out : new FileOutputStream(output);
                this.link(classpath, classes, all, stream, bigEndian);
            }
            catch (FileNotFoundException e) {
                throw new TinyVMException(e.getMessage(), e);
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            if (!(stream instanceof OutputStream)) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new TinyVMException(e);
            }
        }
        if (!(stream instanceof OutputStream)) return;
        try {}
        catch (IOException e) {
            throw new TinyVMException(e);
        }
        stream.close();
    }

    protected CommandLine parse(String[] args) throws TinyVMException {
        CommandLine result;
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        Options options = new Options();
        options.addOption("v", "verbose", false, "print class and signature information");
        options.addOption("h", "help", false, "help");
        Option classpathOption = new Option("cp", "classpath", true, "classpath");
        classpathOption.setArgName("classpath");
        options.addOption(classpathOption);
        Option outputOption = new Option("o", "output", true, "dump binary to file");
        outputOption.setArgName("binary");
        options.addOption(outputOption);
        options.addOption("a", "all", false, "do not filter classes");
        Option writerOrderOption = new Option("wo", "writeorder", true, "write order (BE or LE)");
        writerOrderOption.setArgName("write order");
        options.addOption(writerOrderOption);
        try {
            try {
                result = new GnuParser().parse(options, args);
            }
            catch (ParseException e) {
                throw new TinyVMException(e.getMessage(), e);
            }
            if (result.hasOption("h")) {
                throw new TinyVMException("Help:");
            }
            if (!result.hasOption("cp")) {
                throw new TinyVMException("No classpath defined");
            }
            if (!result.hasOption("wo")) {
                throw new TinyVMException("No write order specified");
            }
            String writeOrder = result.getOptionValue("wo").toLowerCase();
            if (!"be".equals(writeOrder) && !"le".equals(writeOrder)) {
                throw new TinyVMException("Wrong write order: " + writeOrder);
            }
            if (result.getArgs().length == 0) {
                throw new TinyVMException("No classes specified");
            }
        }
        catch (TinyVMException e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println(e.getMessage());
            String usage = this.getClass().getName() + " [options] class1[,class2,...]";
            new HelpFormatter().printHelp(printWriter, 80, usage.toString(), null, options, 0, 2, null);
            throw new TinyVMException(writer.toString());
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    static {
        $assertionsDisabled = !TinyVM.class.desiredAssertionStatus();
    }
}

