/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.old.Constants;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableData;
import js.tinyvm.old.WritableDataWithOffset;

public abstract class RecordTable
extends WritableDataWithOffset
implements Constants {
    int iLength = -1;
    private boolean iAlign;
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public abstract Enumeration elements();

    public abstract int size();

    public abstract Object elementAt(int var1);

    public abstract void add(WritableData var1);

    public RecordTable() {
        this(false);
    }

    public RecordTable(boolean aAlign) {
        this.iAlign = aAlign;
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            boolean pDoVerify = true;
            Enumeration pEnum = this.elements();
            while (pEnum.hasMoreElements()) {
                int pLength = 0;
                int pPrevSize = 0;
                WritableData pData = (WritableData)pEnum.nextElement();
                if (pDoVerify) {
                    pLength = pData.getLength();
                    pPrevSize = aOut.offset();
                }
                pData.dump(aOut);
                if (!pDoVerify || aOut.offset() == pPrevSize + pLength) continue;
                if (pData instanceof RecordTable) {
                    _logger.log(Level.SEVERE, "Aligned sequence: " + ((RecordTable)pData).iAlign);
                }
                throw new TinyVMException("Bug RT-1: Written=" + (aOut.offset() - pPrevSize) + " Length=" + pLength + " Class=" + pData.getClass().getName());
            }
            if (this.iAlign) {
                IOUtilities.writePadding(aOut, 2);
            }
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public int getLength() throws TinyVMException {
        if (this.iLength != -1) {
            return this.iLength;
        }
        this.iLength = 0;
        Enumeration pEnum = this.elements();
        while (pEnum.hasMoreElements()) {
            this.iLength += ((WritableData)pEnum.nextElement()).getLength();
        }
        _logger.log(Level.INFO, "RT.getLength: " + this.iLength);
        if (this.iAlign) {
            this.iLength = IOUtilities.adjustedSize(this.iLength, 2);
        }
        return this.iLength;
    }

    public void initOffset(int aStart) throws TinyVMException {
        _logger.log(Level.INFO, "RT.initOffset: " + aStart);
        super.initOffset(aStart);
        Enumeration pEnum = this.elements();
        while (pEnum.hasMoreElements()) {
            WritableData pElem = (WritableData)pEnum.nextElement();
            if (pElem instanceof WritableDataWithOffset) {
                ((WritableDataWithOffset)pElem).initOffset(aStart);
            }
            aStart += pElem.getLength();
        }
    }
}

