/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.old.Binary;
import js.tinyvm.old.ClassRecord;
import js.tinyvm.old.CodeSequence;
import js.tinyvm.old.CodeUtilities;
import js.tinyvm.old.Constants;
import js.tinyvm.old.ExceptionRecord;
import js.tinyvm.old.RecordTable;
import js.tinyvm.old.Sequence;
import js.tinyvm.old.Signature;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableData;
import js.tinyvm.old.classfile.JCPE_Utf8;
import js.tinyvm.old.classfile.JClassFile;
import js.tinyvm.old.classfile.JClassName;
import js.tinyvm.old.classfile.JCodeAttribute;
import js.tinyvm.old.classfile.JExcep;
import js.tinyvm.old.classfile.JExcepTable;
import js.tinyvm.old.classfile.JMethod;
import js.tinyvm.util.HashVector;

public class MethodRecord
implements WritableData,
Constants {
    JMethod iMethod;
    ClassRecord iClassRecord;
    RecordTable iExceptionTable = null;
    CodeSequence iCodeSequence = null;
    int iSignatureId;
    int iNumLocals;
    int iNumOperands;
    int iNumParameters;
    int iNumExceptionHandlers;
    int iFlags;
    private static final Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MethodRecord(JMethod aEntry, Signature aSignature, ClassRecord aClassRec, Binary aBinary, RecordTable aExceptionTables, HashVector aSignatures) throws TinyVMException {
        boolean pNoBody;
        this.iClassRecord = aClassRec;
        this.iMethod = aEntry;
        JCodeAttribute pCodeAttrib = this.iMethod.getCode();
        boolean bl = pNoBody = this.iMethod.isAbstract() || this.iMethod.isNative();
        if (!$assertionsDisabled && pCodeAttrib == null && !pNoBody) {
            throw new AssertionError((Object)"Check: body is present");
        }
        if (!$assertionsDisabled && pCodeAttrib != null && pNoBody) {
            throw new AssertionError((Object)"Check: no body is present");
        }
        aSignatures.addElement(aSignature);
        this.iSignatureId = aSignatures.indexOf(aSignature);
        if (this.iSignatureId >= 4096) {
            throw new TinyVMException("The total number of unique signatures exceeds 4096");
        }
        int n = this.iNumLocals = pCodeAttrib == null ? 0 : pCodeAttrib.getMaxLocals();
        if (this.iNumLocals > 255) {
            throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has " + this.iNumLocals + " local words. Only " + 255 + " are allowed.");
        }
        int n2 = this.iNumOperands = pCodeAttrib == null ? 0 : pCodeAttrib.getMaxStack();
        if (this.iNumOperands > 255) {
            throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has an operand stack " + " whose potential size is " + this.iNumOperands + ". " + "Only " + 255 + " are allowed.");
        }
        JCPE_Utf8 pDesc = this.iMethod.getDescriptor();
        String[] pParams = JClassName.parseMethodParameters(pDesc);
        this.iNumParameters = MethodRecord.getNumParamWords(this.iMethod, pParams);
        if (this.iNumParameters > 16) {
            throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has " + this.iNumParameters + " parameter words. Only " + 16 + " are allowed.");
        }
        if (this.iMethod.isNative() && !aBinary.isSpecialSignature(aSignature)) {
            _logger.log(Level.WARNING, "Native method signature " + aSignature + " unrecognized. You are probably using JDK APIs " + " or libraries that cannot be run under leJOS.");
        }
        if (pCodeAttrib != null) {
            this.iExceptionTable = new Sequence();
            JExcepTable pExcepTable = pCodeAttrib.getExceptionTable();
            this.iNumExceptionHandlers = pExcepTable.size();
            if (this.iNumExceptionHandlers > 255) {
                throw new TinyVMException("Method " + aClassRec.getName() + "." + this.iMethod.getName() + " has " + this.iNumExceptionHandlers + " exception handlers. Only " + 255 + " are allowed.");
            }
            this.storeExceptionTable(pExcepTable, aBinary, aClassRec.iCF);
            aExceptionTables.add(this.iExceptionTable);
        }
        this.initFlags();
    }

    public int getFlags() {
        return this.iFlags;
    }

    public ClassRecord getClassRecord() {
        return this.iClassRecord;
    }

    public void initFlags() {
        this.iFlags = 0;
        if (this.iMethod.isNative()) {
            this.iFlags |= 1;
        }
        if (this.iMethod.isSynchronized()) {
            this.iFlags |= 2;
        }
        if (this.iMethod.isStatic()) {
            this.iFlags |= 4;
        }
    }

    public void copyCode(RecordTable aCodeSequences, JClassFile aClassFile, Binary aBinary) {
        JCodeAttribute pCodeAttrib = this.iMethod.getCode();
        if (pCodeAttrib != null) {
            this.iCodeSequence = new CodeSequence();
            this.copyCode(pCodeAttrib.getInfo(), aClassFile, aBinary);
            aCodeSequences.add(this.iCodeSequence);
        }
    }

    public void postProcessCode(RecordTable aCodeSequences, JClassFile aClassFile, Binary aBinary) throws TinyVMException {
        JCodeAttribute pCodeAttrib = this.iMethod.getCode();
        if (pCodeAttrib != null) {
            this.postProcessCode(pCodeAttrib.getInfo(), aClassFile, aBinary);
        }
    }

    public static int getNumParamWords(JMethod aMethod, String[] aParamDesc) {
        int pWords = 0;
        block3: for (int i = 0; i < aParamDesc.length; ++i) {
            switch (aParamDesc[i].charAt(0)) {
                case 'D': 
                case 'J': {
                    pWords += 2;
                    continue block3;
                }
                default: {
                    ++pWords;
                }
            }
        }
        return pWords + (aMethod.isStatic() ? 0 : 1);
    }

    public void storeExceptionTable(JExcepTable aExcepTable, Binary aBinary, JClassFile aCF) {
        Enumeration pEnum = aExcepTable.elements();
        while (pEnum.hasMoreElements()) {
            JExcep pExcep = (JExcep)pEnum.nextElement();
            try {
                this.iExceptionTable.add(new ExceptionRecord(pExcep, aBinary, aCF));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void copyCode(byte[] aCode, JClassFile aClassFile, Binary aBinary) {
        if (aCode == null) {
            return;
        }
        this.iCodeSequence.setBytes(aCode);
    }

    public void postProcessCode(byte[] aCode, JClassFile aClassFile, Binary aBinary) throws TinyVMException {
        if (aCode == null) {
            return;
        }
        CodeUtilities pUtils = new CodeUtilities(this.iMethod.getName().toString(), aClassFile, aBinary);
        byte[] pNewCode = pUtils.processCode(aCode);
        this.iCodeSequence.setBytes(pNewCode);
    }

    public int getLength() {
        return IOUtilities.adjustedSize(11, 2);
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            aOut.writeU2(this.iSignatureId);
            aOut.writeU2(this.iExceptionTable == null ? 0 : this.iExceptionTable.getOffset());
            aOut.writeU2(this.iCodeSequence == null ? 0 : this.iCodeSequence.getOffset());
            aOut.writeU1(this.iNumLocals);
            aOut.writeU1(this.iNumOperands);
            aOut.writeU1(this.iNumParameters);
            aOut.writeU1(this.iNumExceptionHandlers);
            aOut.writeU1(this.iFlags);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public int getNumParameterWords() {
        return this.iNumParameters;
    }

    public int getSignatureId() {
        return this.iSignatureId;
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof MethodRecord)) {
            return false;
        }
        return ((MethodRecord)aOther).iMethod.equals(this.iMethod);
    }

    public int hashCode() {
        return this.iMethod.hashCode();
    }

    static {
        $assertionsDisabled = !MethodRecord.class.desiredAssertionStatus();
        _logger = Logger.getLogger("TinyVM");
    }
}

