/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.IOException;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.old.Binary;
import js.tinyvm.old.Constants;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableData;

public class MasterRecord
implements WritableData,
Constants {
    Binary iBinary;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MasterRecord(Binary aBinary) {
        this.iBinary = aBinary;
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        int pMagicNumber = 51958;
        int pConstantTableOffset = this.iBinary.iConstantTable.getOffset();
        if (pConstantTableOffset <= 0 || pConstantTableOffset > 65535) {
            throw new TinyVMException("Bug MR-1: Offset=" + pConstantTableOffset + " CTSize=" + this.iBinary.iConstantTable.size());
        }
        int pStaticFieldsOffset = this.iBinary.iStaticFields.getOffset();
        if (!($assertionsDisabled || pStaticFieldsOffset >= 0 && pStaticFieldsOffset <= 65535)) {
            throw new AssertionError((Object)"Check: static field offset in range");
        }
        int pStaticStateOffset = this.iBinary.iStaticState.getOffset();
        if (!($assertionsDisabled || pStaticStateOffset >= 0 && pStaticStateOffset <= 65535)) {
            throw new AssertionError((Object)"Check: static state offset in range");
        }
        int pStaticStateLength = (this.iBinary.iStaticState.getLength() + 1) / 2;
        if (!($assertionsDisabled || pStaticStateLength >= 0 && pStaticStateLength <= 65535)) {
            throw new AssertionError((Object)"Check: state length in range");
        }
        int pNumStaticFields = this.iBinary.iStaticFields.size();
        int pEntryClassesOffset = this.iBinary.iEntryClassIndices.getOffset();
        int pNumEntryClasses = this.iBinary.iEntryClassIndices.size();
        if (!$assertionsDisabled && pNumEntryClasses >= 256) {
            throw new AssertionError((Object)"Check: not too much classes");
        }
        int pLastClass = this.iBinary.iClassTable.size() - 1;
        if (!($assertionsDisabled || pLastClass >= 0 && pLastClass < 256)) {
            throw new AssertionError((Object)"Check: class index in range");
        }
        try {
            aOut.writeU2(pMagicNumber);
            aOut.writeU2(pConstantTableOffset);
            aOut.writeU2(pStaticFieldsOffset);
            aOut.writeU2(pStaticStateOffset);
            aOut.writeU2(pStaticStateLength);
            aOut.writeU2(pNumStaticFields);
            aOut.writeU2(pEntryClassesOffset);
            aOut.writeU1(pNumEntryClasses);
            aOut.writeU1(pLastClass);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public int getLength() {
        return IOUtilities.adjustedSize(16, 2);
    }

    static {
        $assertionsDisabled = !MasterRecord.class.desiredAssertionStatus();
    }
}

