/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.IOException;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.old.Constants;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableData;
import js.tinyvm.old.classfile.JField;

public class InstanceFieldRecord
implements WritableData,
Constants {
    JField iField;
    int iType;

    public InstanceFieldRecord(JField aEntry) throws TinyVMException {
        this.iField = aEntry;
        this.iType = InstanceFieldRecord.descriptorToType(this.iField.getDescriptor().toString());
    }

    public String getName() {
        return this.iField.getName();
    }

    public static int descriptorToType(String aDesc) throws TinyVMException {
        switch (aDesc.charAt(0)) {
            case 'B': {
                return 8;
            }
            case 'C': {
                return 5;
            }
            case 'D': {
                return 7;
            }
            case 'F': {
                return 6;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
            case 'S': {
                return 9;
            }
            case 'Z': {
                return 4;
            }
            case 'L': 
            case '[': {
                return 0;
            }
        }
        throw new TinyVMException("Bug IFR-2: " + aDesc);
    }

    public int getLength() {
        return 1;
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            aOut.writeU1(this.iType);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public static int getTypeSize(int aType) throws TinyVMException {
        switch (aType) {
            case 4: 
            case 8: {
                return 1;
            }
            case 5: 
            case 9: {
                return 2;
            }
            case 0: 
            case 6: 
            case 10: {
                return 4;
            }
            case 7: 
            case 11: {
                return 8;
            }
        }
        throw new TinyVMException("Bug SV-1: " + aType);
    }

    public int getFieldSize() throws TinyVMException {
        return InstanceFieldRecord.getTypeSize(this.iType);
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof InstanceFieldRecord)) {
            return false;
        }
        return ((InstanceFieldRecord)aOther).iField.equals(this.iField);
    }

    public int hashCode() {
        return this.iField.hashCode();
    }
}

