/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.IOException;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.old.Binary;
import js.tinyvm.old.Constants;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableData;
import js.tinyvm.old.classfile.JCPE_Class;
import js.tinyvm.old.classfile.JClassFile;
import js.tinyvm.old.classfile.JExcep;

public class ExceptionRecord
implements WritableData,
Constants {
    JExcep iExcep;
    int iClassIndex;

    public ExceptionRecord(JExcep aExcep, Binary aBinary, JClassFile aCF) throws Exception {
        this.iExcep = aExcep;
        int pCPIndex = aExcep.getClassIndex();
        if (pCPIndex == 0) {
            this.iClassIndex = aBinary.getClassIndex("java/lang/Throwable");
        } else {
            JCPE_Class pCls = (JCPE_Class)aCF.getConstantPool().getEntry(pCPIndex);
            String pName = pCls.getName();
            this.iClassIndex = aBinary.getClassIndex(pName);
        }
        if (this.iClassIndex == -1) {
            throw new TinyVMException("Exception not found: " + this.iExcep);
        }
    }

    public int getLength() {
        return IOUtilities.adjustedSize(7, 2);
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        int pStart = this.iExcep.getStartPc();
        int pEnd = this.iExcep.getEndPc();
        int pHandler = this.iExcep.getHandlerPc();
        if (pStart > 65535 || pEnd > 65535 || pHandler > 65535) {
            throw new TinyVMException("Exception handler with huge PCs");
        }
        try {
            aOut.writeU2(pStart);
            aOut.writeU2(pEnd);
            aOut.writeU2(pHandler);
            aOut.writeU1(this.iClassIndex);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof ExceptionRecord)) {
            return false;
        }
        return ((ExceptionRecord)aOther).iExcep.equals(this.iExcep);
    }

    public int hashCode() {
        return this.iExcep.hashCode();
    }
}

