/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableDataWithOffset;
import js.tinyvm.old.classfile.JCPE_Double;
import js.tinyvm.old.classfile.JCPE_Float;
import js.tinyvm.old.classfile.JCPE_Integer;
import js.tinyvm.old.classfile.JCPE_Long;
import js.tinyvm.old.classfile.JCPE_String;
import js.tinyvm.old.classfile.JCPE_Utf8;
import js.tinyvm.old.classfile.JConstantPoolEntry;

public class ConstantValue
extends WritableDataWithOffset {
    JConstantPoolEntry iEntry;
    private static final Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConstantValue(JConstantPoolEntry aEntry) {
        this.iEntry = aEntry;
    }

    public int getLength() {
        if (this.iEntry instanceof JCPE_String) {
            JCPE_Utf8 pValue = ((JCPE_String)this.iEntry).getValue();
            return pValue.getSize();
        }
        if (this.iEntry instanceof JCPE_Integer) {
            return 4;
        }
        if (this.iEntry instanceof JCPE_Long) {
            return 8;
        }
        if (this.iEntry instanceof JCPE_Double) {
            return 8;
        }
        if (this.iEntry instanceof JCPE_Float) {
            return 4;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Check: known entry type");
        }
        return 0;
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        try {
            if (this.iEntry instanceof JCPE_String) {
                JCPE_Utf8 pValue = ((JCPE_String)this.iEntry).getValue();
                byte[] pBytes = pValue.getBytes();
                writer.write(pBytes);
            } else if (this.iEntry instanceof JCPE_Integer) {
                int pValue = ((JCPE_Integer)this.iEntry).getValue();
                writer.writeInt(pValue);
            } else if (this.iEntry instanceof JCPE_Long) {
                long pValue = ((JCPE_Long)this.iEntry).getValue();
                int pIntValue = (int)pValue;
                if ((long)pIntValue != pValue) {
                    _logger.log(Level.WARNING, "Long " + pValue + "L truncated to " + pIntValue + ".");
                }
                writer.writeInt(0);
                writer.writeInt(pIntValue);
            } else if (this.iEntry instanceof JCPE_Double) {
                double pDoubleValue = ((JCPE_Double)this.iEntry).getValue();
                float pValue = (float)pDoubleValue;
                if (pDoubleValue != 0.0 && Math.abs((pDoubleValue - (double)pValue) / pDoubleValue) > 0.1) {
                    _logger.log(Level.WARNING, "Double " + pDoubleValue + " truncated to " + pValue + "f.");
                }
                writer.writeInt(0);
                writer.writeInt(Float.floatToIntBits(pValue));
            } else if (this.iEntry instanceof JCPE_Float) {
                float pValue = ((JCPE_Float)this.iEntry).getValue();
                writer.writeInt(Float.floatToIntBits(pValue));
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Check: known entry type");
            }
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean equals(Object aOther) {
        return aOther == this;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    static {
        $assertionsDisabled = !ConstantValue.class.desiredAssertionStatus();
        _logger = Logger.getLogger("TinyVM");
    }
}

