/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.IOException;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.old.ConstantValue;
import js.tinyvm.old.Constants;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableData;
import js.tinyvm.old.classfile.JCPE_Double;
import js.tinyvm.old.classfile.JCPE_Float;
import js.tinyvm.old.classfile.JCPE_Integer;
import js.tinyvm.old.classfile.JCPE_Long;
import js.tinyvm.old.classfile.JCPE_String;
import js.tinyvm.old.classfile.JConstantPoolEntry;

public class ConstantRecord
implements WritableData,
Constants {
    JConstantPoolEntry iEntry;
    ConstantValue iConstantValue;
    int iSize = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConstantRecord(JConstantPoolEntry aEntry) throws TinyVMException {
        this.iEntry = aEntry;
        if (aEntry instanceof JCPE_String) {
            this.iSize = ((JCPE_String)aEntry).getSize();
            if (this.iSize > 255) {
                throw new TinyVMException("String constant of length more than 255 not accepted: " + aEntry);
            }
        } else if (aEntry instanceof JCPE_Double || aEntry instanceof JCPE_Long) {
            this.iSize = 8;
        } else if (aEntry instanceof JCPE_Integer || aEntry instanceof JCPE_Float) {
            this.iSize = 4;
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Check: known entry type");
        }
    }

    public static int getType(JConstantPoolEntry aEntry) {
        if (aEntry instanceof JCPE_String) {
            return 0;
        }
        if (aEntry instanceof JCPE_Double || aEntry instanceof JCPE_Long) {
            return 11;
        }
        if (aEntry instanceof JCPE_Integer) {
            return 10;
        }
        if (aEntry instanceof JCPE_Float) {
            return 6;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Check: known type");
        }
        return -1;
    }

    public void setConstantValue(ConstantValue aValue) {
        this.iConstantValue = aValue;
    }

    public int getLength() {
        return IOUtilities.adjustedSize(4, 2);
    }

    public int getOffset() throws TinyVMException {
        return this.iConstantValue.getOffset();
    }

    public int getConstantSize() {
        return this.iSize;
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        if (!$assertionsDisabled && this.iSize == -1) {
            throw new AssertionError((Object)"Check: iSize != -1");
        }
        if (!$assertionsDisabled && this.iConstantValue == null) {
            throw new AssertionError((Object)"Check: iConstantValue != null");
        }
        try {
            aOut.writeU2(this.iConstantValue.getOffset());
            aOut.writeU1(ConstantRecord.getType(this.iEntry));
            aOut.writeU1(this.iSize);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof ConstantRecord)) {
            return false;
        }
        return ((ConstantRecord)aOther).iEntry.equals(this.iEntry);
    }

    public int hashCode() {
        return this.iEntry.hashCode();
    }

    static {
        $assertionsDisabled = !ConstantRecord.class.desiredAssertionStatus();
    }
}

