/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.old.Binary;
import js.tinyvm.old.ClassRecord;
import js.tinyvm.old.ConstantRecord;
import js.tinyvm.old.Constants;
import js.tinyvm.old.InstanceFieldRecord;
import js.tinyvm.old.MethodRecord;
import js.tinyvm.old.OpCodeConstants;
import js.tinyvm.old.OpCodeInfo;
import js.tinyvm.old.Signature;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.classfile.IConstantPoolEntry;
import js.tinyvm.old.classfile.JCPE_Class;
import js.tinyvm.old.classfile.JCPE_Double;
import js.tinyvm.old.classfile.JCPE_Fieldref;
import js.tinyvm.old.classfile.JCPE_Float;
import js.tinyvm.old.classfile.JCPE_Integer;
import js.tinyvm.old.classfile.JCPE_Long;
import js.tinyvm.old.classfile.JCPE_NameAndType;
import js.tinyvm.old.classfile.JCPE_RefEntry;
import js.tinyvm.old.classfile.JCPE_String;
import js.tinyvm.old.classfile.JClassFile;
import js.tinyvm.old.classfile.JClassName;
import js.tinyvm.old.classfile.JConstantPoolEntry;

public class CodeUtilities
implements OpCodeConstants,
OpCodeInfo,
Constants {
    String iFullName;
    JClassFile iCF;
    Binary iBinary;
    private static final Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CodeUtilities(String aMethodName, JClassFile aCF, Binary aBinary) {
        this.iFullName = CodeUtilities.fullMethod(aCF, aMethodName);
        this.iCF = aCF;
        this.iBinary = aBinary;
    }

    public void exitOnBadOpCode(int aOpCode) throws TinyVMException {
        throw new TinyVMException("Unsupported " + OPCODE_NAME[aOpCode] + " in " + this.iFullName + ".\n" + "The following features/conditions are currently unsupported:\n" + "- Switch statements.\n" + "- Integer increment constant too large. (If > 255, declare it).\n" + "- Arithmetic or logical operations on variables of type long.\n" + "- Remainder operations on floats or doubles.\n" + "- Too many constants or locals ( > 255).\n" + "- Method code too long ( > 64 Kb!).\n" + "");
    }

    public static String fullMethod(JClassFile aCF, String aMethodName) {
        return aCF.getName().toString() + ":" + aMethodName;
    }

    public int processConstantIndex(int aPoolIndex) throws TinyVMException {
        IConstantPoolEntry pEntry = null;
        try {
            pEntry = this.iCF.getConstantPool().getEntry(aPoolIndex);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!(pEntry instanceof JCPE_Integer || pEntry instanceof JCPE_Float || pEntry instanceof JCPE_String || pEntry instanceof JCPE_Double || pEntry instanceof JCPE_Long)) {
            throw new TinyVMException("Classfile error: LDC-type instruction does not refer to a suitable constant. ");
        }
        ConstantRecord pRecord = new ConstantRecord((JConstantPoolEntry)pEntry);
        int pIdx = this.iBinary.getConstantIndex(pRecord);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-2: Didn't find constant " + pEntry + " of class " + pEntry.getClass().getName());
        }
        return pIdx;
    }

    public int processClassIndex(int aPoolIndex) throws TinyVMException {
        IConstantPoolEntry pEntry = null;
        try {
            pEntry = this.iCF.getConstantPool().getEntry(aPoolIndex);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!(pEntry instanceof JCPE_Class)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        JCPE_Class pClassEntry = (JCPE_Class)pEntry;
        String pClassName = pClassEntry.getName();
        if (pClassName.startsWith("[")) {
            throw new TinyVMException("In " + this.iFullName + ": Operations instanceof or " + "checkcast on array classes (" + pClassName + " in this case) are not yet supported by TinyVM.");
        }
        int pIdx = this.iBinary.getClassIndex(pClassName);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pEntry + " from class " + this.iCF.getThisClass().getName());
        }
        return pIdx;
    }

    public int processMultiArray(int aPoolIndex) throws TinyVMException {
        IConstantPoolEntry pEntry = null;
        try {
            pEntry = this.iCF.getConstantPool().getEntry(aPoolIndex);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!(pEntry instanceof JCPE_Class)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        JCPE_Class pClassEntry = (JCPE_Class)pEntry;
        int[] pTypeDim = JClassName.getTypeAndDimensions(pClassEntry.getName());
        if (!$assertionsDisabled && pTypeDim[0] > 255) {
            throw new AssertionError((Object)"Check: correct dimension");
        }
        if (!($assertionsDisabled || pTypeDim[1] > 0 && pTypeDim[1] <= 255)) {
            throw new AssertionError((Object)"Check: correct dimension");
        }
        return pTypeDim[0] << 8 | pTypeDim[1];
    }

    int processField(int aFieldIndex, boolean aStatic) throws TinyVMException {
        IConstantPoolEntry pEntry = null;
        try {
            pEntry = this.iCF.getConstantPool().getEntry(aFieldIndex);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!(pEntry instanceof JCPE_Fieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        JCPE_Fieldref pFieldEntry = (JCPE_Fieldref)pEntry;
        JCPE_Class pClass = pFieldEntry.getClassEntry();
        ClassRecord pClassRecord = this.iBinary.getClassRecord(pClass.getName());
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pClass + " from class " + this.iCF.getThisClass().getName());
        }
        String pName = pFieldEntry.getNameAndType().getName();
        if (aStatic) {
            int pClassIndex = this.iBinary.getClassIndex(pClassRecord);
            if (!($assertionsDisabled || pClassIndex >= 0 && pClassIndex <= 255)) {
                throw new AssertionError((Object)"Check: class index in range");
            }
            int pFieldIndex = pClassRecord.getStaticFieldIndex(pName);
            if (!($assertionsDisabled || pFieldIndex >= 0 && pFieldIndex <= 255)) {
                throw new AssertionError((Object)"Check: field index in range");
            }
            return pClassIndex << 8 | pFieldIndex;
        }
        int pOffset = pClassRecord.getInstanceFieldOffset(pName);
        if (pOffset == -1) {
            throw new TinyVMException("Error: Didn't find field " + pClass + ":" + pName + " from class " + this.iCF.getThisClass().getName());
        }
        if (!$assertionsDisabled && pOffset > 4095) {
            throw new AssertionError((Object)"Check: field offset in range");
        }
        int pFieldType = InstanceFieldRecord.descriptorToType(pFieldEntry.getNameAndType().getDescriptor());
        if (!($assertionsDisabled || pFieldType >= 0 && pFieldType <= 15)) {
            throw new AssertionError((Object)"Check: valid field type");
        }
        return pFieldType << 12 | pOffset;
    }

    int processMethod(int aMethodIndex, boolean aSpecial) throws TinyVMException {
        IConstantPoolEntry pEntry = null;
        try {
            pEntry = this.iCF.getConstantPool().getEntry(aMethodIndex);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!(pEntry instanceof JCPE_RefEntry)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_MethodRef or CONSTANT_InterfaceMethodRef got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        JCPE_RefEntry pMethodEntry = (JCPE_RefEntry)pEntry;
        JCPE_Class pClass = pMethodEntry.getClassEntry();
        String pClassName = pClass.getName();
        ClassRecord pClassRecord = this.iBinary.getClassRecord(pClassName);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-4: Didn't find class " + pClass + " from class " + this.iCF.getThisClass().getName());
        }
        JCPE_NameAndType pNT = pMethodEntry.getNameAndType();
        Signature pSig = new Signature(pNT.getName(), pNT.getDescriptor());
        MethodRecord pMethod = pClassRecord.getVirtualMethodRecord(pSig);
        if (pMethod == null) {
            throw new TinyVMException("Method " + pSig + " not found  in " + pClass);
        }
        ClassRecord pTopClass = pMethod.getClassRecord();
        if (aSpecial) {
            int pClassIndex = this.iBinary.getClassIndex(pTopClass);
            if (!($assertionsDisabled || pClassIndex != -1 && pClassIndex < 256)) {
                throw new AssertionError((Object)"Check: class index in range");
            }
            int pMethodIndex = pTopClass.getMethodIndex(pMethod);
            if (!($assertionsDisabled || pMethodIndex != -1 && pMethodIndex < 255)) {
                throw new AssertionError((Object)"Check: method index in range");
            }
            _logger.log(Level.INFO, "processMethod: special: " + pClassIndex + ", " + pMethodIndex);
            return pClassIndex << 8 | pMethodIndex & 0xFF;
        }
        int pNumParams = pMethod.getNumParameterWords() - 1;
        if (!$assertionsDisabled && pNumParams >= 16) {
            throw new AssertionError((Object)"Check: number of parameters not to high");
        }
        int pSignature = pMethod.getSignatureId();
        if (!$assertionsDisabled && pSignature >= 4096) {
            throw new AssertionError((Object)"Check: signature in range");
        }
        return pNumParams << 12 | pSignature;
    }

    public byte[] processCode(byte[] aCode) throws TinyVMException {
        byte[] pOutCode = new byte[aCode.length];
        int i = 0;
        block14: while (i < aCode.length) {
            pOutCode[i] = aCode[i];
            int pOpCode = pOutCode[i] & 0xFF;
            ++i;
            switch (pOpCode) {
                case 18: {
                    pOutCode[i] = (byte)this.processConstantIndex(aCode[i] & 0xFF);
                    ++i;
                    continue block14;
                }
                case 20: {
                    int pIdx1 = this.processConstantIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx1 >> 8);
                    pOutCode[i++] = (byte)(pIdx1 & 0xFF);
                    continue block14;
                }
                case 189: {
                    pOutCode[i - 1] = -68;
                    pOutCode[i++] = 0;
                    pOutCode[i++] = 0;
                    continue block14;
                }
                case 197: {
                    int pIdx2 = this.processMultiArray((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx2 >> 8);
                    pOutCode[i++] = (byte)(pIdx2 & 0xFF);
                    pOutCode[i] = aCode[i];
                    ++i;
                    continue block14;
                }
                case 187: 
                case 192: 
                case 193: {
                    int pIdx3 = this.processClassIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    if (!$assertionsDisabled && pIdx3 >= 256) {
                        throw new AssertionError((Object)"Check: class index in range");
                    }
                    pOutCode[i++] = (byte)(pIdx3 >> 8);
                    pOutCode[i++] = (byte)(pIdx3 & 0xFF);
                    continue block14;
                }
                case 178: 
                case 179: {
                    int pWord1 = this.processField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true);
                    pOutCode[i++] = (byte)(pWord1 >> 8);
                    pOutCode[i++] = (byte)(pWord1 & 0xFF);
                    continue block14;
                }
                case 180: 
                case 181: {
                    int pWord2 = this.processField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord2 >> 8);
                    pOutCode[i++] = (byte)(pWord2 & 0xFF);
                    continue block14;
                }
                case 185: {
                    pOutCode[i - 1] = -74;
                    int pWord3 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord3 >> 8);
                    pOutCode[i++] = (byte)(pWord3 & 0xFF);
                    pOutCode[i++] = 0;
                    pOutCode[i++] = 0;
                    continue block14;
                }
                case 183: 
                case 184: {
                    int pWord4 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true);
                    pOutCode[i++] = (byte)(pWord4 >> 8);
                    pOutCode[i++] = (byte)(pWord4 & 0xFF);
                    continue block14;
                }
                case 182: {
                    int pWord5 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord5 >> 8);
                    pOutCode[i++] = (byte)(pWord5 & 0xFF);
                    continue block14;
                }
                case 19: 
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: 
                case 148: 
                case 170: 
                case 171: 
                case 196: 
                case 200: 
                case 201: {
                    this.exitOnBadOpCode(pOpCode);
                    continue block14;
                }
                case 202: {
                    throw new TinyVMException("Invalid opcode detected: " + pOpCode + " " + OPCODE_NAME[pOpCode]);
                }
            }
            int pArgs = OPCODE_ARGS[pOpCode];
            if (pArgs == -1) {
                throw new TinyVMException("Bug CU-1: Got " + pOpCode + " in " + this.iFullName + ".");
            }
            for (int ctr = 0; ctr < pArgs; ++ctr) {
                pOutCode[i + ctr] = aCode[i + ctr];
            }
            i += pArgs;
        }
        return pOutCode;
    }

    static {
        $assertionsDisabled = !CodeUtilities.class.desiredAssertionStatus();
        _logger = Logger.getLogger("TinyVM");
    }
}

