/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.old.Binary;
import js.tinyvm.old.ClassPath;
import js.tinyvm.old.ConstantRecord;
import js.tinyvm.old.ConstantValue;
import js.tinyvm.old.Constants;
import js.tinyvm.old.EnumerableSet;
import js.tinyvm.old.InstanceFieldRecord;
import js.tinyvm.old.MethodRecord;
import js.tinyvm.old.RecordTable;
import js.tinyvm.old.Sequence;
import js.tinyvm.old.Signature;
import js.tinyvm.old.StaticFieldRecord;
import js.tinyvm.old.StaticValue;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.old.WritableData;
import js.tinyvm.old.classfile.JCPE_Class;
import js.tinyvm.old.classfile.JCPE_Double;
import js.tinyvm.old.classfile.JCPE_Float;
import js.tinyvm.old.classfile.JCPE_Integer;
import js.tinyvm.old.classfile.JCPE_InterfaceMethodref;
import js.tinyvm.old.classfile.JCPE_Long;
import js.tinyvm.old.classfile.JCPE_Methodref;
import js.tinyvm.old.classfile.JCPE_NameAndType;
import js.tinyvm.old.classfile.JCPE_String;
import js.tinyvm.old.classfile.JClassFile;
import js.tinyvm.old.classfile.JConstantPool;
import js.tinyvm.old.classfile.JConstantPoolEntry;
import js.tinyvm.old.classfile.JField;
import js.tinyvm.old.classfile.JMethod;
import js.tinyvm.util.HashVector;

public class ClassRecord
implements WritableData,
Constants {
    int iIndex = -1;
    String iName;
    int iClassSize = -1;
    JClassFile iCF;
    Binary iBinary;
    final EnumerableSet iMethodTable = new EnumerableSet();
    final RecordTable iInstanceFields = new Sequence();
    final Hashtable iStaticValues = new Hashtable();
    final Hashtable iStaticFields = new Hashtable();
    final Hashtable iMethods = new Hashtable();
    final Vector iUsedMethods = new Vector();
    int iParentClassIndex;
    int iArrayElementType;
    int iFlags;
    boolean iUseAllMethods = false;
    private static final Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void useAllMethods() {
        this.iUseAllMethods = true;
    }

    public String getName() {
        return this.iCF.getName();
    }

    public int getLength() {
        return IOUtilities.adjustedSize(10, 2);
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            int pAllocSize = this.getAllocationSize();
            if (!$assertionsDisabled && pAllocSize == 0) {
                throw new AssertionError((Object)"Check: alloc ok");
            }
            aOut.writeU2(pAllocSize);
            int pMethodTableOffset = this.iMethodTable.getOffset();
            aOut.writeU2(pMethodTableOffset);
            aOut.writeU2(this.iInstanceFields.getOffset());
            int pNumFields = this.iInstanceFields.size();
            if (pNumFields > 255) {
                throw new TinyVMException("Class " + this.iName + ": No more than " + 255 + " fields expected");
            }
            aOut.writeU1(pNumFields);
            int pNumMethods = this.iMethodTable.size();
            if (pNumMethods > 255) {
                throw new TinyVMException("Class " + this.iName + ": No more than " + 255 + " methods expected");
            }
            aOut.writeU1(pNumMethods);
            aOut.writeU1(this.iParentClassIndex);
            aOut.writeU1(this.iFlags);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean isArray() {
        return false;
    }

    public boolean isInterface() {
        return this.iCF.isInterface();
    }

    public boolean hasStaticInitializer() {
        Enumeration pEnum = this.iCF.getMethods().elements();
        while (pEnum.hasMoreElements()) {
            JMethod pMethod = (JMethod)pEnum.nextElement();
            if (!pMethod.getName().toString().equals("<clinit>")) continue;
            return true;
        }
        return false;
    }

    public boolean hasMethod(Signature aSignature, boolean aStatic) {
        MethodRecord pRec = (MethodRecord)this.iMethods.get(aSignature);
        if (pRec == null) {
            return false;
        }
        return (pRec.getFlags() & 4) == 0 ^ aStatic;
    }

    public void initFlags() {
        this.iFlags = 0;
        if (this.isArray()) {
            this.iFlags |= 2;
        }
        if (this.isInterface()) {
            this.iFlags |= 8;
        }
        if (this.hasStaticInitializer()) {
            this.iFlags |= 4;
        }
    }

    public int getAllocationSize() throws TinyVMException {
        return (this.getClassSize() + 5) / 2;
    }

    public int getClassSize() throws TinyVMException {
        if (this.iClassSize != -1) {
            return this.iClassSize;
        }
        this.iClassSize = this.computeClassSize();
        return this.iClassSize;
    }

    public int computeClassSize() throws TinyVMException {
        ClassRecord pParent = this.getParent();
        int pSize = pParent != null ? pParent.getClassSize() : 0;
        Enumeration pEnum = this.iInstanceFields.elements();
        while (pEnum.hasMoreElements()) {
            InstanceFieldRecord pRec = (InstanceFieldRecord)pEnum.nextElement();
            pSize += pRec.getFieldSize();
        }
        return pSize;
    }

    public ClassRecord getParent() {
        JCPE_Class pParent = this.iCF.getSuperClass();
        if (pParent == null) {
            return null;
        }
        ClassRecord pRec = this.iBinary.getClassRecord(pParent.getName().toString());
        return pRec;
    }

    public void initParent() throws TinyVMException {
        ClassRecord pRec = this.getParent();
        if (pRec == null) {
            this.iParentClassIndex = 0;
            if (!this.iCF.getName().equals("java/lang/Object")) {
                throw new TinyVMException("Expected java.lang.Object");
            }
        } else {
            this.iParentClassIndex = this.iBinary.getClassIndex(pRec);
            if (this.iParentClassIndex == -1) {
                throw new TinyVMException("Class not found");
            }
        }
    }

    public void storeReferredClasses(Hashtable aClasses, RecordTable aClassRecords, ClassPath aClassPath, Vector aInterfaceMethods) throws TinyVMException {
        _logger.log(Level.INFO, "Processing CONSTANT_Class entries in " + this.iName);
        JConstantPool pPool = this.iCF.getConstantPool();
        Enumeration pEntries = pPool.elements();
        while (pEntries.hasMoreElements()) {
            JConstantPoolEntry pEntry = (JConstantPoolEntry)pEntries.nextElement();
            if (pEntry instanceof JCPE_Class) {
                String pClassName = ((JCPE_Class)pEntry).getName();
                if (pClassName.startsWith("[")) {
                    _logger.log(Level.INFO, "Skipping array: " + pClassName);
                    continue;
                }
                if (aClasses.get(pClassName) != null) continue;
                ClassRecord pRec = ClassRecord.getClassRecord(pClassName, aClassPath, this.iBinary);
                aClasses.put(pClassName, pRec);
                aClassRecords.add(pRec);
                continue;
            }
            if (pEntry instanceof JCPE_Methodref) {
                JCPE_Class pClass = ((JCPE_Methodref)pEntry).getClassEntry();
                ClassRecord pClassRec = (ClassRecord)aClasses.get(pClass.getName());
                if (pClassRec == null) {
                    pClassRec = ClassRecord.getClassRecord(pClass.getName(), aClassPath, this.iBinary);
                    aClasses.put(pClass.getName(), pClassRec);
                    aClassRecords.add(pClassRec);
                }
                pClassRec.addUsedMethod(((JCPE_Methodref)pEntry).getNameAndType().getName() + ":" + ((JCPE_Methodref)pEntry).getNameAndType().getDescriptor());
                continue;
            }
            if (pEntry instanceof JCPE_InterfaceMethodref) {
                aInterfaceMethods.addElement(((JCPE_InterfaceMethodref)pEntry).getNameAndType().getName() + ":" + ((JCPE_InterfaceMethodref)pEntry).getNameAndType().getDescriptor());
                continue;
            }
            if (!(pEntry instanceof JCPE_NameAndType) || !((JCPE_NameAndType)pEntry).getDescriptor().substring(0, 1).equals("(") || ((JCPE_NameAndType)pEntry).getName().substring(0, 1).equals("<")) continue;
            aInterfaceMethods.addElement(((JCPE_NameAndType)pEntry).getName() + ":" + ((JCPE_NameAndType)pEntry).getDescriptor());
        }
    }

    public void addUsedMethod(String aRef) {
        this.iUsedMethods.addElement(aRef);
    }

    public static String cpEntryId(JConstantPoolEntry aEntry) {
        String pClassName = aEntry.getClass().getName();
        int pDotIdx = pClassName.lastIndexOf(46);
        return pDotIdx == -1 ? pClassName : pClassName.substring(pDotIdx + 1);
    }

    MethodRecord getMethodRecord(Signature aSig) {
        return (MethodRecord)this.iMethods.get(aSig);
    }

    MethodRecord getVirtualMethodRecord(Signature aSig) {
        MethodRecord pRec = this.getMethodRecord(aSig);
        if (pRec != null) {
            return pRec;
        }
        ClassRecord pParent = this.getParent();
        if (pParent == null) {
            return null;
        }
        return pParent.getVirtualMethodRecord(aSig);
    }

    int getMethodIndex(MethodRecord aRecord) {
        return this.iMethodTable.indexOf(aRecord);
    }

    int getApparentInstanceFieldOffset(String aName) throws TinyVMException {
        ClassRecord pParent = this.getParent();
        int pOffset = pParent != null ? pParent.getClassSize() : 0;
        Enumeration pEnum = this.iInstanceFields.elements();
        while (pEnum.hasMoreElements()) {
            InstanceFieldRecord pRec = (InstanceFieldRecord)pEnum.nextElement();
            if (pRec.getName().equals(aName)) {
                return pOffset;
            }
            pOffset += pRec.getFieldSize();
        }
        return -1;
    }

    public int getInstanceFieldOffset(String aName) throws TinyVMException {
        return this.getApparentInstanceFieldOffset(aName) + 4;
    }

    public int getStaticFieldOffset(String aName) throws TinyVMException {
        StaticValue pValue = (StaticValue)this.iStaticValues.get(aName);
        if (pValue == null) {
            return -1;
        }
        return pValue.getOffset() - this.iBinary.iStaticState.getOffset();
    }

    public int getStaticFieldIndex(String aName) {
        StaticFieldRecord pRecord = (StaticFieldRecord)this.iStaticFields.get(aName);
        if (pRecord == null) {
            return -1;
        }
        return ((Sequence)this.iBinary.iStaticFields).indexOf(pRecord);
    }

    public void storeConstants(RecordTable aConstantTable, RecordTable aConstantValues) throws TinyVMException {
        _logger.log(Level.INFO, "Processing other constants in " + this.iName);
        EnumerableSet pConstantSet = (EnumerableSet)aConstantTable;
        JConstantPool pPool = this.iCF.getConstantPool();
        Enumeration pEntries = pPool.elements();
        while (pEntries.hasMoreElements()) {
            JConstantPoolEntry pEntry = (JConstantPoolEntry)pEntries.nextElement();
            if (!(pEntry instanceof JCPE_String) && !(pEntry instanceof JCPE_Double) && !(pEntry instanceof JCPE_Float) && !(pEntry instanceof JCPE_Integer) && !(pEntry instanceof JCPE_Long)) continue;
            ConstantRecord pRec = new ConstantRecord(pEntry);
            pRec.toString();
            if (pConstantSet.contains(pRec)) continue;
            ConstantValue pValue = new ConstantValue(pEntry);
            pRec.setConstantValue(pValue);
            pConstantSet.add(pRec);
            aConstantValues.add(pValue);
        }
    }

    public void storeMethods(RecordTable aMethodTables, RecordTable aExceptionTables, HashVector aSignatures, boolean aAll, PrintWriter aWriter) throws TinyVMException {
        _logger.log(Level.INFO, "Processing methods in " + this.iName);
        Enumeration pEntries = this.iCF.getMethods().elements();
        while (pEntries.hasMoreElements()) {
            JMethod pMethod = (JMethod)pEntries.nextElement();
            Signature pSignature = new Signature(pMethod.getName(), pMethod.getDescriptor());
            String meth = pMethod.getName() + ":" + pMethod.getDescriptor();
            if (aAll || this.iUseAllMethods || this.iUsedMethods.indexOf(meth) >= 0 || pMethod.getName().substring(0, 1).equals("<") || meth.equals("run:()V")) {
                MethodRecord pMethodRecord = new MethodRecord(pMethod, pSignature, this, this.iBinary, aExceptionTables, aSignatures);
                this.iMethodTable.add(pMethodRecord);
                this.iMethods.put(pSignature, pMethodRecord);
                continue;
            }
            _logger.log(Level.INFO, "Omitting " + meth + " for class " + this.iName);
            aWriter.println("Omitting " + meth + " for class " + this.iName);
        }
        aMethodTables.add(this.iMethodTable);
    }

    public void storeFields(RecordTable aInstanceFieldTables, RecordTable aStaticFields, RecordTable aStaticState) throws TinyVMException {
        _logger.log(Level.INFO, "Processing methods in " + this.iName);
        Enumeration pEntries = this.iCF.getFields().elements();
        while (pEntries.hasMoreElements()) {
            JField pField = (JField)pEntries.nextElement();
            if (pField.isStatic()) {
                StaticValue pValue = new StaticValue(pField);
                StaticFieldRecord pRec = new StaticFieldRecord(pField, this);
                String pName = pField.getName().toString();
                if (!$assertionsDisabled && this.iStaticValues.containsKey(pName)) {
                    throw new AssertionError((Object)"Check: value not static");
                }
                this.iStaticValues.put(pName, pValue);
                this.iStaticFields.put(pName, pRec);
                aStaticState.add(pValue);
                aStaticFields.add(pRec);
                continue;
            }
            this.iInstanceFields.add(new InstanceFieldRecord(pField));
        }
        aInstanceFieldTables.add(this.iInstanceFields);
    }

    public void storeCode(RecordTable aCodeSequences, boolean aPostProcess) throws TinyVMException {
        Enumeration pMethods = this.iMethodTable.elements();
        while (pMethods.hasMoreElements()) {
            MethodRecord pRec = (MethodRecord)pMethods.nextElement();
            if (aPostProcess) {
                pRec.postProcessCode(aCodeSequences, this.iCF, this.iBinary);
                continue;
            }
            pRec.copyCode(aCodeSequences, this.iCF, this.iBinary);
        }
    }

    public static ClassRecord getClassRecord(String aName, ClassPath aCP, Binary aBinary) throws TinyVMException {
        InputStream pIn = aCP.getInputStream(aName);
        if (pIn == null) {
            throw new TinyVMException("Class " + aName.replace('/', '.') + " (file " + aName + ".class) not found in CLASSPATH " + aCP);
        }
        ClassRecord pCR = new ClassRecord();
        try {
            pCR.iBinary = aBinary;
            pCR.iCF = new JClassFile();
            pCR.iName = aName;
            BufferedInputStream pBufIn = new BufferedInputStream(pIn, 4096);
            pCR.iCF.read(pBufIn);
            ((InputStream)pBufIn).close();
        }
        catch (Exception e) {
            throw new TinyVMException(e.getMessage(), e);
        }
        return pCR;
    }

    public String toString() {
        return this.iName;
    }

    public int hashCode() {
        return this.iName.hashCode();
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof ClassRecord)) {
            return false;
        }
        ClassRecord pOther = (ClassRecord)aObj;
        return pOther.iName.equals(this.iName);
    }

    static {
        $assertionsDisabled = !ClassRecord.class.desiredAssertionStatus();
        _logger = Logger.getLogger("TinyVM");
    }
}

