/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import js.tinyvm.old.TinyVMException;

public class ClassPath {
    private Object[] iEntries;

    public ClassPath(String aEntries) throws TinyVMException {
        Vector<String> pTokens = new Vector<String>();
        StringTokenizer pTok = new StringTokenizer(aEntries, File.pathSeparator);
        while (pTok.hasMoreTokens()) {
            pTokens.addElement(pTok.nextToken());
        }
        this.iEntries = new Object[pTokens.size()];
        for (int i = 0; i < this.iEntries.length; ++i) {
            String pEntry = (String)pTokens.elementAt(i);
            if (pEntry.endsWith(".zip") || pEntry.endsWith(".jar")) {
                try {
                    this.iEntries[i] = new ZipFile(pEntry);
                    continue;
                }
                catch (IOException e) {
                    throw new TinyVMException("Can't open zip/jar file " + pEntry);
                }
            }
            this.iEntries[i] = new File(pEntry);
            if (((File)this.iEntries[i]).isDirectory()) continue;
            throw new TinyVMException(pEntry + " is not a directory");
        }
    }

    public InputStream getInputStream(String aName) throws TinyVMException {
        try {
            String pRelName = aName + ".class";
            for (int i = 0; i < this.iEntries.length; ++i) {
                ZipFile pZipFile;
                ZipEntry pEntry;
                if (this.iEntries[i] instanceof File) {
                    File pClassFile = new File((File)this.iEntries[i], pRelName);
                    if (!pClassFile.exists()) continue;
                    return new FileInputStream(pClassFile);
                }
                if (!(this.iEntries[i] instanceof ZipFile) || (pEntry = (pZipFile = (ZipFile)this.iEntries[i]).getEntry(pRelName)) == null) continue;
                return pZipFile.getInputStream(pEntry);
            }
        }
        catch (FileNotFoundException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
        return null;
    }

    public String toString() {
        StringBuffer pBuf = new StringBuffer();
        for (int i = 0; i < this.iEntries.length; ++i) {
            if (this.iEntries[i] instanceof ZipFile) {
                pBuf.append(((ZipFile)this.iEntries[i]).getName());
            } else {
                pBuf.append(this.iEntries[i]);
            }
            if (i >= this.iEntries.length - 1) continue;
            pBuf.append(File.pathSeparator);
        }
        return pBuf.toString();
    }
}

