/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.old;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.old.ClassPath;
import js.tinyvm.old.ClassRecord;
import js.tinyvm.old.ConstantRecord;
import js.tinyvm.old.EntryClassIndex;
import js.tinyvm.old.EnumerableSet;
import js.tinyvm.old.MasterRecord;
import js.tinyvm.old.RecordTable;
import js.tinyvm.old.Sequence;
import js.tinyvm.old.Signature;
import js.tinyvm.old.SpecialClassConstants;
import js.tinyvm.old.SpecialSignatureConstants;
import js.tinyvm.old.TinyVMException;
import js.tinyvm.util.HashVector;

public class Binary
implements SpecialClassConstants,
SpecialSignatureConstants {
    private StringWriter stringWriter;
    private PrintWriter signatureWriter;
    final RecordTable iEntireBinary = new Sequence();
    final MasterRecord iMasterRecord = new MasterRecord(this);
    final EnumerableSet iClassTable = new EnumerableSet();
    final EnumerableSet iConstantTable = new EnumerableSet();
    final RecordTable iEntryClassIndices = new Sequence();
    final RecordTable iMethodTables = new Sequence();
    final RecordTable iInstanceFieldTables = new Sequence();
    final RecordTable iStaticFields = new Sequence();
    final RecordTable iExceptionTables = new EnumerableSet();
    final RecordTable iStaticState = new Sequence(true);
    final RecordTable iCodeSequences = new Sequence();
    final RecordTable iConstantValues = new Sequence();
    final Hashtable iSpecialSignatures = new Hashtable();
    final Hashtable iClasses = new Hashtable();
    final HashVector iSignatures = new HashVector();
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public Binary() {
        this.stringWriter = new StringWriter();
        this.signatureWriter = new PrintWriter(System.out);
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        this.iEntireBinary.dump(aOut);
    }

    public boolean hasMain(String aClassName) {
        ClassRecord pRec = this.getClassRecord(aClassName);
        return pRec.hasMethod(new Signature("main", "([Ljava/lang/String;)V"), true);
    }

    public ClassRecord getClassRecord(String aClassName) {
        return (ClassRecord)this.iClasses.get(aClassName);
    }

    public int getClassIndex(String aClassName) {
        return this.getClassIndex(this.getClassRecord(aClassName));
    }

    public int getClassIndex(ClassRecord aRec) {
        if (aRec == null) {
            return -1;
        }
        return this.iClassTable.indexOf(aRec);
    }

    public int getConstantIndex(ConstantRecord aRec) {
        if (aRec == null) {
            return -1;
        }
        return this.iConstantTable.indexOf(aRec);
    }

    public ConstantRecord getConstantRecord(int aIndex) {
        return (ConstantRecord)this.iConstantTable.elementAt(aIndex);
    }

    public void processClasses(Vector aEntryClasses, ClassPath aClassPath) throws TinyVMException {
        ClassRecord pRec;
        ClassRecord pRec2;
        Vector pInterfaceMethods = new Vector();
        for (int i = 0; i < CLASSES.length; ++i) {
            String pName = CLASSES[i];
            pRec2 = ClassRecord.getClassRecord(pName, aClassPath, this);
            this.iClasses.put(pName, pRec2);
            this.iClassTable.add(pRec2);
        }
        int pEntrySize = aEntryClasses.size();
        for (int i = 0; i < pEntrySize; ++i) {
            String pName = (String)aEntryClasses.elementAt(i);
            pRec = ClassRecord.getClassRecord(pName, aClassPath, this);
            this.iClasses.put(pName, pRec);
            this.iClassTable.add(pRec);
            pRec.useAllMethods();
            this.iEntryClassIndices.add(new EntryClassIndex(this, pName));
        }
        _logger.log(Level.INFO, "Starting with " + this.iClassTable.size() + " classes.");
        for (int pIndex = 0; pIndex < this.iClassTable.size(); ++pIndex) {
            pRec2 = (ClassRecord)this.iClassTable.elementAt(pIndex);
            _logger.log(Level.INFO, "Class " + pIndex + ": " + pRec2.iName);
            this.appendSignature("Class " + pIndex + ": " + pRec2.iName);
            pRec2.storeReferredClasses(this.iClasses, this.iClassTable, aClassPath, pInterfaceMethods);
        }
        int pSize = this.iClassTable.size();
        int pIndex = 0;
        while (pIndex < pSize) {
            pRec = (ClassRecord)this.iClassTable.elementAt(pIndex);
            for (int i = 0; i < pInterfaceMethods.size(); ++i) {
                pRec.addUsedMethod((String)pInterfaceMethods.elementAt(i));
            }
            pRec.iIndex = pIndex++;
            pRec.initFlags();
            pRec.initParent();
        }
    }

    public void processSpecialSignatures() {
        for (int i = 0; i < SIGNATURES.length; ++i) {
            Signature pSig = new Signature(SIGNATURES[i]);
            this.iSignatures.addElement(pSig);
            this.iSpecialSignatures.put(pSig, SIGNATURES[i]);
        }
    }

    public boolean isSpecialSignature(Signature aSig) {
        return this.iSpecialSignatures.containsKey(aSig);
    }

    public void processConstants() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.elementAt(pIndex);
            pRec.storeConstants(this.iConstantTable, this.iConstantValues);
        }
    }

    public void processMethods(boolean iAll) throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.elementAt(pIndex);
            pRec.storeMethods(this.iMethodTables, this.iExceptionTables, this.iSignatures, iAll, this.signatureWriter);
        }
    }

    public void processFields() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.elementAt(pIndex);
            pRec.storeFields(this.iInstanceFieldTables, this.iStaticFields, this.iStaticState);
        }
    }

    public void processCode(boolean aPostProcess) throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.elementAt(pIndex);
            pRec.storeCode(this.iCodeSequences, aPostProcess);
        }
    }

    public void storeComponents() {
        this.iEntireBinary.add(this.iMasterRecord);
        this.iEntireBinary.add(this.iClassTable);
        this.iEntireBinary.add(this.iStaticState);
        this.iEntireBinary.add(this.iStaticFields);
        this.iEntireBinary.add(this.iConstantTable);
        this.iEntireBinary.add(this.iMethodTables);
        this.iEntireBinary.add(this.iExceptionTables);
        this.iEntireBinary.add(this.iInstanceFieldTables);
        this.iEntireBinary.add(this.iCodeSequences);
        this.iEntireBinary.add(this.iConstantValues);
        this.iEntireBinary.add(this.iEntryClassIndices);
    }

    public void initOffsets() throws TinyVMException {
        this.iEntireBinary.initOffset(0);
    }

    public int getTotalNumMethods() {
        int pTotal = 0;
        int pSize = this.iMethodTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += ((RecordTable)this.iMethodTables.elementAt(i)).size();
        }
        return pTotal;
    }

    public int getTotalNumInstanceFields() {
        int pTotal = 0;
        int pSize = this.iInstanceFieldTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += ((RecordTable)this.iInstanceFieldTables.elementAt(i)).size();
        }
        return pTotal;
    }

    public void report() throws TinyVMException {
        int pSize = this.iSignatures.size();
        for (int i = 0; i < pSize; ++i) {
            Signature pSig = (Signature)this.iSignatures.elementAt(i);
            _logger.log(Level.INFO, "Signature " + i + ": " + pSig.getImage());
            this.appendSignature("Signature " + i + ": " + pSig.getImage());
        }
        _logger.log(Level.INFO, "Master record : " + this.iMasterRecord.getLength() + " bytes.");
        this.appendSignature("Master record : " + this.iMasterRecord.getLength() + " bytes.");
        _logger.log(Level.INFO, "Class records : " + this.iClassTable.size() + " (" + this.iClassTable.getLength() + " bytes).");
        this.appendSignature("Class records : " + this.iClassTable.size() + " (" + this.iClassTable.getLength() + " bytes).");
        _logger.log(Level.INFO, "Field records : " + this.getTotalNumInstanceFields() + " (" + this.iInstanceFieldTables.getLength() + " bytes).");
        this.appendSignature("Field records : " + this.getTotalNumInstanceFields() + " (" + this.iInstanceFieldTables.getLength() + " bytes).");
        _logger.log(Level.INFO, "Method records: " + this.getTotalNumMethods() + " (" + this.iMethodTables.getLength() + " bytes).");
        this.appendSignature("Method records: " + this.getTotalNumMethods() + " (" + this.iMethodTables.getLength() + " bytes).");
        _logger.log(Level.INFO, "Code          : " + this.iCodeSequences.size() + " (" + this.iCodeSequences.getLength() + " bytes).");
        this.appendSignature("Code          : " + this.iCodeSequences.size() + " (" + this.iCodeSequences.getLength() + " bytes).");
        _logger.log(Level.INFO, "Class table offset   : " + this.iClassTable.getOffset());
        this.appendSignature("Class table offset   : " + this.iClassTable.getOffset());
        _logger.log(Level.INFO, "Constant table offset: " + this.iConstantTable.getOffset());
        this.appendSignature("Constant table offset: " + this.iConstantTable.getOffset());
        _logger.log(Level.INFO, "Method tables offset : " + this.iMethodTables.getOffset());
        this.appendSignature("Method tables offset : " + this.iMethodTables.getOffset());
        _logger.log(Level.INFO, "Excep tables offset  : " + this.iExceptionTables.getOffset());
        this.appendSignature("Excep tables offset  : " + this.iExceptionTables.getOffset());
    }

    public void appendSignature(String msg) {
        this.signatureWriter.println(msg);
        this.signatureWriter.flush();
    }

    public void flushSignatureFile(File aFile) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(aFile));
        pw.print(this.stringWriter.toString());
        pw.flush();
        pw.close();
    }

    public static Binary createFromClosureOf(Vector aEntryClasses, ClassPath aClassPath, boolean aAll) throws TinyVMException {
        Binary pBin = new Binary();
        pBin.processClasses(aEntryClasses, aClassPath);
        pBin.processSpecialSignatures();
        pBin.processConstants();
        pBin.processMethods(aAll);
        pBin.processFields();
        pBin.processCode(false);
        pBin.storeComponents();
        pBin.initOffsets();
        pBin.processCode(true);
        pBin.report();
        return pBin;
    }
}

