/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.gameboy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tinyvm.TinyVMException;
import js.tinyvm.gameboy.GameboyMerger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Gameboydl {
    private ToolProgressMonitor _progress = null;
    private boolean _verbose = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] args) {
        try {
            Gameboydl tinyVM = new Gameboydl(new CLIToolProgressMonitor());
            tinyVM.start(args);
        }
        catch (TinyVMException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public Gameboydl(ToolProgressMonitor monitor) {
        if (!$assertionsDisabled && monitor == null) {
            throw new AssertionError((Object)"Precondition: monitor != null");
        }
        this._progress = monitor;
    }

    public void start(String[] args) throws TinyVMException {
        CommandLine commandLine = this.parse(args);
        this._verbose = commandLine.hasOption("v");
        String input = commandLine.getOptionValue("i");
        String[] classes = commandLine.getArgs();
        try {
            InputStream stream = input == null ? System.in : new FileInputStream(input);
            this.download(stream, classes[0]);
        }
        catch (FileNotFoundException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    protected CommandLine parse(String[] args) throws TinyVMException {
        CommandLine result;
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError((Object)"Precondition: args != null");
        }
        Options options = new Options();
        options.addOption("v", "verbose", false, "print class and signature information");
        Option inputOption = new Option("i", "input", true, "binary to download");
        inputOption.setArgName("binary");
        options.addOption(inputOption);
        try {
            try {
                result = new GnuParser().parse(options, args);
            }
            catch (ParseException e) {
                throw new TinyVMException(e.getMessage(), e);
            }
            if (result.getArgs().length == 0) {
                throw new TinyVMException("No class specified");
            }
            if (result.getArgs().length > 1) {
                throw new TinyVMException("More than one class specified");
            }
        }
        catch (TinyVMException e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println(e.getMessage());
            String usage = this.getClass().getName() + " [options] class";
            new HelpFormatter().printHelp(printWriter, 80, usage, null, options, 0, 2, null);
            throw new TinyVMException(writer.toString());
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    public void download(InputStream stream, String mainClass) throws TinyVMException {
        try {
            GameboyMerger merger = new GameboyMerger(System.getProperty("temp.dir"));
            merger.dumpRom(stream, mainClass);
        }
        catch (Exception e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    static {
        $assertionsDisabled = !Gameboydl.class.desiredAssertionStatus();
    }
}

