/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm.gameboy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class GameboyMerger {
    String tempDir;
    String compiler;

    public GameboyMerger(String tmpDir) {
        this.tempDir = tmpDir == null ? "." : tmpDir;
        this.compiler = "lcc";
    }

    String getByteCodeFile(String className) {
        File dirFile = new File(this.tempDir);
        return new File(dirFile, "gb$" + className + ".c").getPath();
    }

    String getRomFile(String className) {
        return className + ".gb";
    }

    public void dumpRom(InputStream stream, String className) throws IOException {
        String cfile = this.getByteCodeFile(className);
        this.dumpByteCodeFile(stream, cfile);
        String outfile = this.getRomFile(className);
    }

    void dumpByteCodeFile(InputStream stream, String outputFile) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile), 4096));
        out.println("/* Machine generated temp file */");
        out.println();
        out.println("#include <asm/types.h>");
        out.println();
        out.println("UINT8 lejos_code[] = {");
        this.dumpByteCodeList(stream, out);
        out.println("};");
        out.close();
    }

    void dumpByteCodeList(InputStream stream, PrintWriter out) throws IOException {
        int b;
        int i = 0;
        while ((b = stream.read()) != -1) {
            out.print("0x" + Integer.toHexString((byte)b & 0xFF));
            out.print(", ");
            if (i % 10 == 0) {
                out.println();
            }
            ++i;
        }
    }
}

